package org.xydra.index;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/**
 * Commonly used helper functions.
 *
 * @author dscharrer
 *
 */
public class XI {

	/**
	 * Check if the two objects are equal. The given objects can be null. Two
	 * null objects are equals and any non-null object is not equal to null.
	 *
	 * @param a
	 * @param b
	 * @return true if a and b are the same reference (can be both null) or if
	 *         they are not null and equal.
	 */
	public static boolean equals(final Object a, final Object b) {
		return a == b || a != null && a.equals(b);
	}

	/**
	 * Checks if two iterators have the same elements in the same order.
	 *
	 * @param a
	 * @param b
	 *
	 * @return true if both iterators have the same number of elements and each
	 *         pair of elements is equal.
	 */
	static public boolean equalsIterator(final Iterator<?> a, final Iterator<?> b) {
		while (a.hasNext()) {
			if (!b.hasNext()) {
				return false;
			}
			if (!XI.equals(a.next(), b.next())) {
				return false;
			}
		}
		return !b.hasNext();
	}

	@SuppressWarnings("unchecked")
	public static <T> Set<T> toJavaSet(final IEntrySet<T> entrySet) {
		if (entrySet instanceof Set) {
			/* if created with FastEntrySetFactory, this works */
			return (Set<T>) entrySet;
		} // else: convert
		final Iterator<T> it = entrySet.iterator();
		final Set<T> result = new HashSet<T>();
		while (it.hasNext()) {
			final T xid = it.next();
			result.add(xid);
		}
		return result;
	}

}
