package de.xam.tupleinf.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map.Entry;
import java.util.Set;

import org.xydra.index.IEntrySet;
import org.xydra.index.impl.FastEntrySetFactory;
import org.xydra.index.impl.MapSetIndex;
import org.xydra.index.impl.SmallEntrySetFactory;
import org.xydra.index.iterator.Iterators;
import org.xydra.index.query.Constraint;
import org.xydra.index.query.EqualsConstraint;
import org.xydra.index.query.KeyEntryTuple;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

import de.xam.tupleinf.IInverseTransitiveTupleIndex;
import de.xam.tupleinf.ITupleSink;
import de.xam.tupleinf.InfLayerRead;

/**
 * TODO optimisation opportunity for case transitive & symmetric (as it is the case for 'sameAs'): map all ids to the
 * SAME set of linked ids; requires to filter out the redundant self-link; saves some memory. On delete of a tuple,
 * every remaining tuple needs to be checked, if it still holds. If many tuples are deleted, a complete re-inference
 * might be faster. see {@link SymmetricTransitiveTupleIndex}
 *
 * @author xamde
 *
 * @param <T>
 */
public class ITTI_Fast2<T> extends ITTI_Base<T>implements IInverseTransitiveTupleIndex<T> {

	private static final Logger log = LoggerFactory.getLogger(ITTI_Fast2.class);

	/** Copy of all indexed tuples p.os */
	protected final MapSetIndex<T, T> baseTuples;

	/** Inverse and transitive tuples; contains only tuples not in base */
	protected final MapSetIndex<T, T> infdTuples;

	private ITupleSink<T> optionalTupleSink;

	public ITTI_Fast2(final T p) {
		this(p, false);
	}

	public ITTI_Fast2(final T p, final boolean concurrent) {
		super(p, concurrent);
		this.baseTuples = new MapSetIndex<T, T>(new FastEntrySetFactory<T>(concurrent), concurrent);
		this.infdTuples = new MapSetIndex<T, T>(new FastEntrySetFactory<T>(concurrent), concurrent);

		checkAssertions();
		assert isPrimary();
	}

	@Override
	protected void do__clearBase() {
		this.baseTuples.clear();
		do__markInferenceAsDirty();
	}

	@Override
	protected void do__clearInfd() {
		this.infdTuples.clear();
	}

	@Override
	protected void do__contentToString(final StringBuilder buf) {
		buf.append("---baseTuples---\n");
		buf.append(this.baseTuples.toString() + "\n");
		buf.append("---infTuples---\n");
		buf.append(this.infdTuples.toString() + "\n");
	}

	@Override
	protected void do__dumpContent() {
		if (!this.baseTuples.isEmpty()) {
			log.info("--- BaseTuples");
			this.baseTuples.dump();
		}
		if (!this.infdTuples.isEmpty()) {
			log.info("--- InfTuples");
			this.infdTuples.dump();
		}
	}

	@Override
	protected void primary__inference() {
		if (log.isDebugEnabled()) {
			log.debug("doInference");
		}

		// reset completely and infer incrementally from there
		// do__clearInfd();
		/* trigger inference, now all tuples can be found with right-joins only */
		do__markInferenceAsComplete();
		// self-add all existing tuples once

		// TODO ???????????
		// final List<KeyEntryTuple<T, T>> list = Iterators.toList(this.primary__tupleIterator(this.ANY,
		// this.ANY));
		// for(final KeyEntryTuple<T, T> baseOrInfdTuple : list) {
		// primary__inferFrom(baseOrInfdTuple.getFirst(), baseOrInfdTuple.getSecond());
		// }

		final Iterator<KeyEntryTuple<T, T>> baseOrInfdIt_AB = this.primary__tupleIterator(this.ANY, this.ANY,InfLayerRead.Both);
		while (baseOrInfdIt_AB.hasNext()) {
			final KeyEntryTuple<T, T> baseOrInfdTuple = baseOrInfdIt_AB.next();
			primary__inferFrom(baseOrInfdTuple.getFirst(), baseOrInfdTuple.getSecond());
		}

		assert isInferenceComplete();
	}

	/**
	 * A single tuple cannot result in multiple identical tuples. However, inferring from n tuples can result in
	 * inferring the same tuple twice. Proof:
	 *
	 * Infer from (a,b), (b,z), (a,c),(c,z) => (a,z) is inferred twice
	 *
	 * For a given tuple (a,b), we need to search all (a,?c). If we found a really new tuple, we need to infer again
	 * from there. So we go 'further right' by looking for (?c,?d) from which we infer(a,?d) and continue searching for
	 * (?d,?e?)...
	 *
	 * So the general form is: We search for (x,?y) with an initial x=b
	 *
	 * @param a tuple.first from which we infer
	 * @param b tuple.second from which we infer
	 * @return true if at least one new tuple was inferred
	 */
	/* source code syntax: lowercase = bound variable; uppercase X = free variable */
	protected final boolean primary__inferFrom(final T a, final T b) {
		assert isPrimary();

		boolean newTuples = false;
		newTuples |= primary__inferTransitiveFrom(a, b);
		// newTuples |= primary__inferSymmericFrom(a, b);
		return newTuples;
	}

	@SuppressWarnings("unused")
	private boolean primary__inferSymmericFrom(final T a, final T b) {
		if (!primary__isSymmetric()) {
			return false;
		}

		if (this.baseTuples.contains(b, a)) {
			return false;
		}
		// maybe index
		return this.infdTuples.index(b, a);
	}

	private boolean primary__inferTransitiveFrom(final T a, final T b) {
		if (!primary__isTransitive()) {
			return false;
		}

		boolean inferredNew = false;
		MapSetIndex<T, T> checkTuples = new MapSetIndex<T, T>(new SmallEntrySetFactory<T>());
		checkTuples.index(a, b);
		do {
			final MapSetIndex<T, T> checkNewTuples = new MapSetIndex<T, T>(new SmallEntrySetFactory<T>());

			for (final Entry<T, IEntrySet<T>> e : checkTuples.getEntries()) {
				for (final T g : e.getValue()) {
					final T f = e.getKey();
					primary_inferTransitive_right_from(f, g, checkNewTuples);
					primary_inferTransitive_left_from(f, g, checkNewTuples);
				}
			}
			checkTuples = checkNewTuples;
			inferredNew |= checkTuples.isEmpty();
		} while (!checkTuples.isEmpty());
		return inferredNew;
	}

	// now also look left. we can do far less optimisations here.
	private boolean primary_inferTransitive_left_from(final T a, final T b, final MapSetIndex<T, T> newTuples) {
		final boolean trace = log.isTraceEnabled();

		/* (?w,?v)(?v,b) -> (?w,b) */
		Set<T> Vb = new HashSet<T>();
		Vb.add(a);
		do {
			final Set<T> Wb = new HashSet<T>();
			for (final T v : Vb) {
				final EqualsConstraint<T> cV = new EqualsConstraint<T>(v);

				Iterator<KeyEntryTuple<T, T>> Wv_it;
				Wv_it = this.baseTuples.tupleIterator(this.ANY, cV);
				if (trace && Wv_it.hasNext()) {
					log.trace("   BASE: Infer from (" + "?w" + "," + v + ")(" + v + "," + b + "), ?w="
							+ Iterators.toList(this.baseTuples.tupleIterator(this.ANY, cV)));
				}
				primary__inferTransitiveStep_left(b, v, Wv_it, Wb, newTuples);

				// HERE-----------
				Wv_it = this.infdTuples.tupleIterator(this.ANY, cV);
				if (trace && Wv_it.hasNext()) {
					log.trace("   INFD: Infer from (" + "?w" + "," + v + ")(" + v + "," + b + "), ?w="
							+ Iterators.toList(this.infdTuples.tupleIterator(this.ANY, cV)));
				}
				primary__inferTransitiveStep_left(b, v, Wv_it, Wb, newTuples);
			}
			// one step left
			Vb = Wb;
		} while (!Vb.isEmpty());
		return !Vb.isEmpty();
	}

	private boolean primary_inferTransitive_right_from(final T a, final T b, final MapSetIndex<T, T> newTuples) {
		final boolean trace = log.isTraceEnabled();

		/* (a,?x)(?x,?y) -> (a,?y) */
		final IEntrySet<T> base_aY = this.baseTuples.lookup(a);
		IEntrySet<T> infd_aY = null;

		if (trace) {
			log.trace("(" + a + "," + b + ")  infer with   base(" + a + ",?) = " + base_aY + ";   inf(" + a + ",?) = "
					+ infd_aY + "");
		}

		Set<T> aX = new HashSet<T>();
		aX.add(b);
		do {
			if (trace) {
				log.trace("    ---- aX = " + aX);
			}
			/* if we indexed new tuples in the last round, this is now non-null, but was null before. When null, we
			 * cannot see updates. */
			if (infd_aY == null) {
				infd_aY = this.infdTuples.lookup(a);
			}

			final Set<T> aY = new HashSet<T>();
			for (final T x : aX) {

				final IEntrySet<T> base_xY = this.baseTuples.lookup(x);
				if (trace && base_xY != null) {
					log.trace("   BASE: Infer from (" + a + "," + x + ")(" + x + ",?) =" + base_xY + " into aY=" + aY);
				}
				primary__inferTransitiveStep_right(a, x, base_xY, base_aY, infd_aY, aY, newTuples);

				final IEntrySet<T> infd_xY = this.infdTuples.lookup(x);
				if (trace && infd_xY != null) {
					log.trace("   INFD: Infer from (" + a + "," + x + ")(" + x + ",?) =" + infd_xY + " into aY=" + aY);
				}
				primary__inferTransitiveStep_right(a, x, infd_xY, base_aY, infd_aY, aY, newTuples);
			}
			// one step right
			aX = aY;
		} while (!aX.isEmpty());
		return !aX.isEmpty();
	}

	private void primary__inferTransitiveStep_left(final T b, final T v, final Iterator<KeyEntryTuple<T, T>> wv_it,
			final Set<T> wSet, final MapSetIndex<T, T> newTuples) {
		while (wv_it.hasNext()) {
			final KeyEntryTuple<T, T> wv = wv_it.next();
			assert wv.getSecond().equals(v) : "second=" + wv.getSecond() + " v=" + v;
			final T w = wv.getFirst();
			if (!this.baseTuples.contains(w, b)) {
				final boolean notYetInInf = this.infdTuples.index(w, b);
				if (notYetInInf) {
					log.trace("      +New (" + w + "," + b + ")");
					wSet.add(w);
					newTuples.index(w, b);
					if (this.optionalTupleSink != null) {
						this.optionalTupleSink.index(w, b);
					}
				} else {
					log.trace("      +old (" + w + "," + b + ")");
				}
			}
		}
	}

	@Override
	public boolean equals(final Object obj) {
		if (!(obj instanceof ITTI_Fast2)) {
			return false;
		}
		@SuppressWarnings("unchecked") final ITTI_Fast2<T> other = (ITTI_Fast2<T>) obj;
		return this.p.equals(other.p) && this.flagSymmetric == other.flagSymmetric
				&& this.flagTransitive == other.flagTransitive && isPrimary() == other.isPrimary()
				&& this.baseTuples.equals(other.baseTuples);
	}

	@Override
	public int hashCode() {
		return this.p.hashCode();// + this.baseTuples.hashCode();
	}

	/**
	 * Checks only if a new (a,y) is not already known - and indexes in this case.
	 *
	 * @param a
	 * @param x IMPROVE present only for debugging - slower?
	 * @param xY source
	 * @param base_aY source
	 * @param infd_aY source
	 * @param aY_target target
	 * @param newTuples
	 */
	private void primary__inferTransitiveStep_right(final T a, final T x, final IEntrySet<T> xY,
			final IEntrySet<T> base_aY, final IEntrySet<T> infd_aY, final Set<T> aY_target,
			final MapSetIndex<T, T> newTuples) {
		if (xY == null) {
			return;
		}

		final boolean trace = log.isTraceEnabled();
		/* for (a,x) we found (x,?y) => infer (a,?y)
		 *
		 * Have we found a really new tuple? */
		for (final T y : xY) {
			if (base_aY == null || !base_aY.contains(y)) {
				// persist
				boolean notYetInInf;
				if (infd_aY == null) {
					// implicitly creates infSet_aY
					this.infdTuples.index(a, y);
					notYetInInf = true;
				} else {
					notYetInInf = infd_aY.index(y);
				}
				// remember internally
				if (notYetInInf) {
					aY_target.add(y);
					newTuples.index(a, y);
					if (this.optionalTupleSink != null) {
						this.optionalTupleSink.index(a, y);
					}
					if (trace) {
						log.trace("      +New (" + a + "," + y + ")");
					}
				}
			} else {
				if (trace) {
					log.trace("      -Old (" + a + "," + y + ")");
				}
			}
		}
	}

	@Override
	public Iterator<KeyEntryTuple<T, T>> primary__baseTupleIterator() {
		return this.baseTuples.tupleIterator(this.ANY, this.ANY);
	}

	@Override
	protected void primary__clearAll() {
		this.baseTuples.clear();
		this.infdTuples.clear();
	}

	@Override
	protected boolean primary__contains(final Constraint<T> cA, final Constraint<T> cB, final InfLayerRead infLayer) {
		primary__ensureInference();

		// if(isSymmetric()) {
		// return
		// /* cA, cB */
		// this.baseTuples.contains(cA, cB) || this.infdTuples.contains(cA, cB)
		// ||
		// /* cB, cA */
		// this.baseTuples.contains(cB, cA) || this.infdTuples.contains(cB, cA);
		// }
		//
		/* cA, cB */
		return this.baseTuples.contains(cA, cB) || this.infdTuples.contains(cA, cB);
	}

	@Override
	protected boolean primary__contains(final T a, final T b, final InfLayerRead infLayer) {
		primary__ensureInference();

		// if(isSymmetric()) {
		// return
		// /* a,b */
		// this.baseTuples.contains(a, b) || this.infdTuples.contains(a, b) ||
		// /* b,a */
		// this.baseTuples.contains(b, a) || this.infdTuples.contains(b, a);
		// }

		/* a,b */
		return this.baseTuples.contains(a, b) || this.infdTuples.contains(a, b);
	}

	@Override
	protected boolean primary__deIndex(final T a, final T b) {
		do__markInferenceAsDirty();
		return this.baseTuples.deIndex(a, b);
	}

	@Override
	protected boolean primary__index(final T a, final T b) {
		final boolean added = this.baseTuples.index(a, b);
		if (!added) {
			return false;
		}

		// remove tuple from inf tuples
		final boolean infRemoved = this.infdTuples.deIndex(a, b);
		if (infRemoved) {
			// we just shifted a tuple from infd to base, cannot cause inference
			return true;
		}

		// if(a.equals(b) && isSymmetric()) {
		// // nothing to infer
		// return added;
		// }

		if (primary__isTransitive()) {
			if (isInferenceComplete()) {
				if (log.isDebugEnabled()) {
					log.debug("incremental inference");
				}
				primary__inferFrom(a, b);
			} else {
				assert!isInferenceComplete() : "dirty flag is set anyway";
			}
		}

		return added;
	}

	@Override
	protected boolean primary__isEmpty() {
		return this.baseTuples.isEmpty() && this.infdTuples.isEmpty();
	}

	@Override
	protected Iterator<T> primary__query_aX_project_X(final Constraint<T> cA, final InfLayerRead infLayer) {
		primary__ensureInference();

		final Iterator<T> aX_it1 = this.baseTuples.constraintIterator(cA);
		final Iterator<T> aX_it2 = this.infdTuples.constraintIterator(cA);

		// if(isSymmetric()) {
		// Iterator<T> aX_it3 = getInverseIndex().query_Xb_project_X(cA);
		// return Iterators.concat(aX_it1, aX_it2, aX_it3);
		// }

		return Iterators.concat(aX_it1, aX_it2);
	}

	@Override
	public Iterator<KeyEntryTuple<T, T>> primary__tupleIterator(final Constraint<T> cA, final Constraint<T> cB, final InfLayerRead infLayer) {
		checkAssertions();
		assert isPrimary();
		if (log.isDebugEnabled()) {
			log.debug(getP() + ".(" + cA + ", " + cB + ")");
		}

		primary__ensureInference();
		return do__tupleIterator(cA, cB);
	}

	@Override
	public Iterator<KeyEntryTuple<T, T>> primary__tuples(final InfLayerRead infLayer) {
		checkAssertions();
		assert isPrimary();
		if (log.isDebugEnabled()) {
			log.debug(getP() + ".()");
		}

		primary__ensureInference();
		return do__tuples();
	}

	protected Iterator<KeyEntryTuple<T, T>> do__tuples() {
		final Iterator<KeyEntryTuple<T, T>> result = Iterators.concat(
				/* cA, cB */
				this.baseTuples.tuples(), this.infdTuples.tuples());
		return result;
	}

	@Override
	protected Iterator<KeyEntryTuple<T, T>> do__tupleIterator(final Constraint<T> cA, final Constraint<T> cB) {
		final Iterator<KeyEntryTuple<T, T>> result = Iterators.concat(
				/* cA, cB */
				this.baseTuples.tupleIterator(cA, cB), this.infdTuples.tupleIterator(cA, cB));

		// /*
		// * Ask baseTuples and infTuples in the same way.
		// *
		// * Symmetric: For every pair (a,b) the pair (b,a) is also true.
		// *
		// * For a query (cA,cB) the correct answer is: tuples(cA,cB) +
		// * inverted(tuples(cB,cA))
		// */
		// result = Iterators.concat(
		// /* cA, cB */
		// this.baseTuples.tupleIterator(cA, cB),
		// this.infdTuples.tupleIterator(cA, cB),
		// /* inverted */
		// invert(this.baseTuples.tupleIterator(cB, cA)),
		// invert(this.infdTuples.tupleIterator(cB, cA)));

		return result;
	}

	@Override
	public boolean indexInfd(final T a, final T b) {
		if (this.baseTuples.contains(a, b)) {
			return false;
		}

		final boolean added = this.infdTuples.index(a, b);
		if (added) {
			this.primary__inferFrom(a, b);
		}
		return added;
	}

	@Override
	public boolean deIndexInfd(final T a, final T b) {
		return this.infdTuples.deIndex(a, b);
	}

	@Override
	public void setInfdTupleSink(final ITupleSink<T> tupleSink) {
		this.optionalTupleSink = tupleSink;
	}

}
