package de.xam.tupleinf;

import java.io.Serializable;
import java.util.Iterator;

import org.xydra.index.IEntrySet;
import org.xydra.index.IMapSetIndex;
import org.xydra.index.ISerializableMapSetIndex;
import org.xydra.index.iterator.ClosableIterator;
import org.xydra.index.iterator.Iterators;
import org.xydra.index.query.Constraint;
import org.xydra.index.query.KeyEntryTuple;

/**
 * Reads go to primary and secondary layer; write affect only secondary. So deleting some existing tuple might have no
 * effect if the triple was in the primary layer.
 *
 * @author xamde
 *
 * @param <K>
 * @param <E>
 */
public class CombinedTupleIndex<K extends Serializable, E extends Serializable> implements ISerializableMapSetIndex<K, E> {

	public CombinedTupleIndex(final IMapSetIndex<K, E> a, final IMapSetIndex<K, E> b) {
		this.a = a;
		this.b = b;
	}

	public static <K extends Serializable, E extends Serializable> IMapSetIndex<K, E> combine(final IMapSetIndex<K, E> a, final IMapSetIndex<K, E> b) {
		if (a == b) {
			return a;
		}
		return new CombinedTupleIndex<K, E>(a, b);
	}

	@Override
	public void clear() {
		this.a.clear();
		this.b.clear();
	}

	@Override
	public boolean isEmpty() {
		return this.a.isEmpty() && this.b.isEmpty();
	}

	@Override
	public ClosableIterator<E> constraintIterator(final Constraint<K> c1) {
		return Iterators.concat(this.a.constraintIterator(c1), this.b.constraintIterator(c1));
	}

	@Override
	public boolean contains(final Constraint<K> c1, final Constraint<E> entryConstraint) {
		return this.a.contains(c1, entryConstraint) || this.b.contains(c1, entryConstraint);
	}

	@Override
	public boolean contains(final K k, final E e) {
		return this.a.contains(k, e) || this.b.contains(k, e);
	}

	@Override
	public boolean containsKey(final K key) {
		return this.a.containsKey(key) || this.b.containsKey(key);
	}

	@Override
	public boolean deIndex(final K key1, final E entry) {
		if (this.a.contains(key1, entry)) {
			return false;
		}
		return this.b.deIndex(key1, entry);
	}

	@Override
	public boolean deIndex(final K key1) {
		return this.b.deIndex(key1);
	}

	@Override
	public boolean index(final K key1, final E entry) {
		if (this.a.contains(key1, entry)) {
			return false;
		}

		return this.b.index(key1, entry);
	}

	@Override
	public Iterator<KeyEntryTuple<K, E>> tupleIterator(final Constraint<K> c1, final Constraint<E> entryConstraint) {
		return Iterators.concat(this.a.tupleIterator(c1, entryConstraint), this.b.tupleIterator(c1, entryConstraint));
	}

	// can contain duplicates
	@Override
	public Iterator<K> keyIterator() {
		return Iterators.concat(this.a.keyIterator(), this.b.keyIterator());
	}

	@Override
	public org.xydra.index.IMapSetIndex.IMapSetDiff<K, E> computeDiff(final IMapSetIndex<K, E> otherFuture) {
		throw new UnsupportedOperationException();
	}

	@Override
	public IEntrySet<E> lookup(final K key) {
		return CombinedEntrySet.combine(this.a.lookup(key), this.b.lookup(key));
	}

	private final IMapSetIndex<K, E> a;

	private final IMapSetIndex<K, E> b;

	@Override
	public String toString() {
		return toString("");
	}

	@Override
	public String toString(final String indent) {
		final StringBuilder b = new StringBuilder();
		b.append(indent + "A:\n");
		b.append(indent + this.a.toString());
		b.append(indent + "B:\n");
		b.append(indent + b.toString());
		return b.toString();
	}

}
