package de.xam.triplerules;

import org.xydra.index.ITripleIndex;
import org.xydra.index.query.Constraint;

import de.xam.triplerules.impl.ICostEstimator;

public interface IRuleEngine<K, L, M> {

	/**
	 * @param rule
	 */
	void addRule(ITripleRule<K, L, M> rule);

	/**
	 * @param costEstimator
	 */
	void setCostEstimator(ICostEstimator<K, L, M> costEstimator);

	/**
	 * Compute all inferences and write them into target
	 *
	 * @param sourceTripleIndex needs  {@link ITripleIndex#getTriples(Constraint, Constraint, Constraint)} TODO more...
	 * @param targetTripleIndex needs to implement only {@link ITripleIndex#contains(Object, Object, Object)}
	 */
	void inferAll(ITripleIndex<K, L, M> sourceTripleIndex, ITripleIndex<K, L, M> targetTripleIndex);

}
