package de.xam.textsearch.tokenize;

import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.regexp.shared.SplitResult;

/**
 * An {@link ITokenizer} using a regex internally
 *
 * @author xamde
 */
public class RegexTokenizer implements ITokenizer {

	private final RegExp splitRegex;

	public RegexTokenizer(final String splitRegex) {
		this.splitRegex = RegExp.compile(splitRegex);
	}

	@Override
	public synchronized SplitResult split(final String term) {
		assert term != null;
		// performance: re-use compiled regex
		return this.splitRegex.split(term);
	}
}
