package de.xam.textsearch.text;

import java.util.List;

import de.xam.textsearch.query.IQuery;

/**
 * A text query delivers some more information for ranking.
 *
 * @author xamde
 *
 * @param <V>
 */
public interface ITextQuery<V> extends IQuery<V> {

	/** @return the original complete, search phrase */
	String getPhrase();

	/** @return a sorted set */
	List<String> getWords();

	/** @return a sorted set */
	List<String> getFragments();

}
