package de.xam.textsearch.compare;

import java.util.Comparator;

import de.xam.textsearch.spi.IContentResolver;

/**
 * Comparing Vs is done by comparing the projected string content of the value
 * objects
 */
public class LexicographicContentComperator<V> implements Comparator<V> {

	public LexicographicContentComperator(final IContentResolver<V> contentResolver) {
		this.contentResolver = contentResolver;
	}

	private final IContentResolver<V> contentResolver;

	@Override
	public int compare(final V a, final V b) {
		return compare_static(a, b, this.contentResolver);
	}

	public static <T> int compare_static(final T a, final T b, final IContentResolver<T> contentResolver) {
		final String aContent = contentResolver.getContentAsStringForTextIndexing(a);
		final String bContent = contentResolver.getContentAsStringForTextIndexing(b);
		return aContent.compareTo(bContent);
	}

}
