package de.xam.texthtml.markdown;

import org.pegdown.PegDownProcessor;

public class Markdown {

	private static PegDownProcessor pegdown;

	/**
	 * @param in
	 * @return html
	 */
	public static synchronized String interpretMarkdown(final String in) {
		if (pegdown == null) {
			pegdown = new PegDownProcessor();
		}

		/**
		 * If you'd like to customize the rendering of HTML links (Auto-Links,
		 * Explicit-Links, Mail-Links, Reference-Links and/or Wiki-Links), e.g.
		 * for adding rel="nofollow" attributes based on some logic you can
		 * supply your own instance of a LinkRenderer with the call to
		 * markdownToHtml.
		 */
		return pegdown.markdownToHtml(in);
	}

}
