package de.xam.p13n.shared.time;

import org.xydra.annotations.RunsInGWT;

@RunsInGWT(true)
public class SharedTimeUtils {

	/**
	 * @param start
	 *            UTC millisecond timepoint
	 * @param end
	 *            UTC millisecond timepoint
	 * @return number of weeks between start and end, ignoring "Schaltsekunden"
	 */
	public static int weeksBetween(final long start, final long end) {
		final long d_ms = end - start;
		final int d_weeks = (int) (d_ms / (1000 * 60 * 60 * 24 * 7));
		return d_weeks;
	}

}
