package de.xam.p13n.shared.time;

import java.io.Serializable;

import org.xydra.annotations.RequiresAppEngine;
import org.xydra.annotations.RunsInAppEngine;
import org.xydra.annotations.RunsInGWT;

/**
 * @author xamde
 *
 */
@RunsInGWT(true)
@RunsInAppEngine(true)
@RequiresAppEngine(false)
public class MiniTimeZone implements Serializable {

	private static final long serialVersionUID = -3608883372057165964L;

	// IMPROVE 2012-03 Timezone delta cannot be constant -- offset must come
	// from server
	public static final MiniTimeZone GERMANY_BERLIN = new MiniTimeZone("Europe/Berlin", 1);

	// IMPROVE 2012-03 Timezone delta cannot be constant -- offset must come
	// from server
	public static final MiniTimeZone US_SAN_FRANCISCO = new MiniTimeZone("America/Los_Angeles", -8);

	public static final String TIMEZONE_ID_UNKNOWN = "Unknown";

	public static MiniTimeZone fromString(final String timeZoneString) {
		final int lastSlash = timeZoneString.lastIndexOf("/");
		if (lastSlash <= 0) {
			throw new IllegalArgumentException("No slash / found");
		}
		final String timeZoneId = timeZoneString.substring(0, lastSlash);
		String offset = timeZoneString.substring(lastSlash + 1);
		try {
			if (offset.startsWith("+")) {
				offset = offset.substring(1);
			}
			/*
			 * work around Blackberry bug
			 * http://code.google.com/p/google-web-toolkit/issues/detail?id=7291
			 */
			final int utcOffset = (int) Long.parseLong(offset);
			return new MiniTimeZone(timeZoneId, utcOffset);
		} catch (final NumberFormatException e) {
			throw new IllegalArgumentException(e);
		}
	}

	private String timeZoneId;

	private int utcOffset;

	/** For GWT only */
	public MiniTimeZone() {
	}

	/**
	 * @param utcOffset
	 *            in milliseconds
	 */
	public MiniTimeZone(final int utcOffset) {
		this.utcOffset = utcOffset;
		this.timeZoneId = TIMEZONE_ID_UNKNOWN;
	}

	/**
	 * @param timeZoneId
	 *            as defined by Java/Olson
	 * @param utcOffset
	 *            in milliseconds
	 */
	public MiniTimeZone(final String timeZoneId, final int utcOffset) {
		this.timeZoneId = timeZoneId;
		this.utcOffset = utcOffset;
	}

	@Override
	public boolean equals(final Object other) {
		return other instanceof MiniTimeZone
				&& ((MiniTimeZone) other).timeZoneId.equalsIgnoreCase(this.timeZoneId);
	}

	public String getCountryCode() {
		return TzDatabase.getEntryForTimeZoneName(this.timeZoneId).countryCode;
	}

	public String getTimeZoneId() {
		return this.timeZoneId;
	}

	/**
	 * @return UTC offset in milliseconds in effect at current time
	 */
	public int getUtcOffset() {
		return this.utcOffset;
	}

	@Override
	public int hashCode() {
		return this.timeZoneId.hashCode();
	}

	/**
	 * @return A unique, parse-able String
	 */
	public String toCompactString() {
		return this.timeZoneId + "/" + this.utcOffset;
	}

}
