package de.xam.p13n.shared;

import org.xydra.annotations.RequiresAppEngine;
import org.xydra.annotations.RunsInAppEngine;
import org.xydra.annotations.RunsInGWT;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

/**
 * Utility class to guess p13n preferences from HTTP headers.
 *
 * @author xamde
 *
 */
@RunsInAppEngine(true)
@RequiresAppEngine(false)
@RunsInGWT(true)
public class SharedP13nUtils {

	@SuppressWarnings("unused")
	private static final Logger log = LoggerFactory.getLogger(SharedP13nUtils.class);

	/**
	 * Language variant for debugger-type of person.
	 */
	public static String VARIANT_DEBUGGER = "debug";

	/**
	 * Language variant for web designer-type of person.
	 */
	public static String VARIANT_LOREM_IPSUM = "lorem";

	/**
	 * @param p13n
	 *            {@link Personalisation} to be checked
	 * @return true if {@link Personalisation} has a language variant that
	 *         indicates he/she is a debugger person.
	 */
	public static boolean isDebugger(final Personalisation p13n) {
		return p13n.getLocale().getVariant() != null

		&& p13n.getLocale().getVariant().equalsIgnoreCase(VARIANT_DEBUGGER);
	}

	/**
	 * @param p13n
	 *            {@link Personalisation} to be checked
	 * @return if {@link Personalisation} has a language variant that indicates
	 *         the user is a web designer and wants to replace all text by lorem
	 *         ipsum.
	 */
	public static boolean isLoremIpsum(final Personalisation p13n) {
		return p13n.getLocale().getVariant() != null

		&& p13n.getLocale().getVariant().equalsIgnoreCase(VARIANT_LOREM_IPSUM);
	}

	private static final String ALPHABET = "abcdefghijklmnopqrstuvwxyzäöüßABCDEFGHIJKLMNOPQRSTUVWXYZÄÖÜ";

	public static String loremIpsum(final String s) {
		final StringBuffer buf = new StringBuffer();
		for (int i = 0; i < s.length(); i++) {
			final char c = s.charAt(i);
			if (c == ' ') {
				buf.append(c);
			} else {
				final int j = (int) (Math.random() * (ALPHABET.length() - 1));
				final char replacement = ALPHABET.charAt(j);
				buf.append(replacement);
			}
		}
		return buf.toString();
	}
}
