package de.xam.p13n.shared;

import org.xydra.annotations.RequiresAppEngine;
import org.xydra.annotations.RunsInAppEngine;
import org.xydra.annotations.RunsInGWT;

/**
 * Represents a choice of language, optionally a given country, and optionally
 * (and orthogonal) a language variant.
 *
 * Normalizes all values to lowercase.
 *
 * Any two-letter primary-tag is an ISO-639 language abbreviation and any
 * two-letter initial subtag is an ISO-3166 country code.
 *
 * IMPROVE 2012-05 P13n: add these: Chinese Accept-Language: zh
 *
 * English Accept-Language: en
 *
 * French Accept-Language: fr
 *
 * German Accept-Language: de
 *
 * Japanese Accept-Language: ja
 *
 * Spanish Accept-Language: es
 *
 * @author xamde
 */
@RunsInGWT(true)
@RunsInAppEngine(true)
@RequiresAppEngine(false)
public class SharedLocaleUtils {

	/**
	 * @param s
	 *            Format: 'en_GB' or 'en_US_funny' or '_GB_funny' or 'en__funny'
	 * @return a MiniLocale
	 */
	public static MiniLocale fromString(final String s) {
		assert s != null;

		if (s.equals("ROOT")) {
			getRootLocale();
		}

		// language
		final int languageIndex = s.indexOf('_');
		String language = null;
		if (languageIndex == -1) {
			return new MiniLocale(s, "");
		} else {
			language = s.substring(0, languageIndex);
		}

		// country
		final int countryIndex = s.indexOf('_', languageIndex + 1);
		String country = null;
		if (countryIndex == -1) {
			country = s.substring(languageIndex + 1);
			return new MiniLocale(language, country);
		} else {
			// all remaining is the variant
			country = s.substring(languageIndex + 1, countryIndex);
			final String variant = s.substring(countryIndex + 1);
			return new MiniLocale(language, country, variant);
		}
	}

	protected static MiniLocale getRootLocale() {
		return new MiniLocale("ROOT");
	}

	/**
	 * @param locale
	 *            never null
	 * @param precision
	 *            3 for high precision down to 0 = no precision
	 * @return e.g. "en-us-slang"
	 */
	public static String toString(final MiniLocale locale, final int precision) {
		final StringBuffer buf = new StringBuffer();
		if (precision > 0) {
			buf.append(locale.getLanguage());
			if (precision > 1) {
				if (locale.getCountry() != null) {
					buf.append("_");
					buf.append(locale.getCountry());
				}
				if (precision > 2) {
					if (locale.getVariant() != null) {
						buf.append("_");
						buf.append(locale.getVariant());
					}
				}
			}
		}
		return buf.toString();
	}

}
