package de.xam.p13n.shared;

import java.util.Stack;

import org.xydra.annotations.RequiresAppEngine;
import org.xydra.annotations.RunsInAppEngine;
import org.xydra.annotations.RunsInGWT;

@RunsInGWT(true)
@RunsInAppEngine(true)
@RequiresAppEngine(false)
public class P13nSearchUtils {

	/**
	 * @param packageName
	 *            in usual dot-notation
	 * @param p13n
	 *            may be null
	 * @param resourceNamePrefix
	 *            never null, may be empty String
	 * @param resourceNameExtension
	 *            without '.'
	 * @return a list of message resource files to look for in order to resolve
	 *         a given {@link Personalisation}. Resources are named "MSG.utf8",
	 *         "MSG_en.uft8", "MSG.en_use.uft8", and "MSG_en_us_casual" etc.
	 */
	public static Stack<String> getFromGeneralToSpecific(final String packageName, final Personalisation p13n,
			final String resourceNamePrefix, final String resourceNameExtension) {
		assert packageName != null;
		assert resourceNamePrefix != null;
		assert resourceNameExtension != null;

		final Stack<String> fromGeneralToSpecific = new Stack<String>();

		if (p13n == null) {
			String searchName = packageName + "." + resourceNamePrefix;
			searchName = searchName.replace(".", "/");
			final String resourceName = searchName + "." + resourceNameExtension;
			if (!fromGeneralToSpecific.contains(resourceName)) {
				fromGeneralToSpecific.push(resourceName);
			}
		} else {
			short precision = 3;
			// prepare list
			for (precision = 3; precision >= 0; precision--) {
				String searchName = packageName + "." + resourceNamePrefix;
				searchName = searchName.replace(".", "/");
				final String resourceName = searchName + p13n.toClassifier(precision) + "."
						+ resourceNameExtension;
				if (!fromGeneralToSpecific.contains(resourceName)) {
					fromGeneralToSpecific.push(resourceName);
				}
			}
		}

		return fromGeneralToSpecific;
	}

}
