package de.xam.googleanalytics;

/**
 * An event that can be tracked in GA
 *
 * @author xamde
 *
 */
public class GaEvent {

	String category, action, optionalLabel = null;
	int optionalValue = -1;

	/**
	 * Parameter need not to be URL-encoded
	 *
	 * @param category
	 *            to be tracked
	 * @param action
	 *            to be tracked
	 * @param optionalLabel
	 *            to be tracked
	 * @param optionalValue
	 *            to be tracked
	 */
	public GaEvent(final String category, final String action, final String optionalLabel, final int optionalValue) {
		super();
		this.category = category;
		this.action = action;
		this.optionalLabel = optionalLabel;
		this.optionalValue = optionalValue;
	}

	/**
	 * Parameter need not to be URL-encoded
	 *
	 * @param category
	 *            to be tracked
	 * @param action
	 *            to be tracked
	 * @param optionalLabel
	 *            to be tracked
	 */
	public GaEvent(final String category, final String action, final String optionalLabel) {
		super();
		this.category = category;
		this.action = action;
		this.optionalLabel = optionalLabel;
	}

	/**
	 * Parameter need not to be URL-encoded
	 *
	 * @param category
	 *            to be tracked
	 * @param action
	 *            to be tracked
	 * @param optionalValue
	 *            to be tracked
	 */
	public GaEvent(final String category, final String action, final int optionalValue) {
		super();
		this.category = category;
		this.action = action;
		this.optionalValue = optionalValue;
	}

	/**
	 * Parameter need not to be URL-encoded
	 *
	 * @param category
	 *            to be tracked
	 * @param action
	 *            to be tracked
	 */
	public GaEvent(final String category, final String action) {
		super();
		this.category = category;
		this.action = action;
	}

}
