/* part_d3.vm ##
##
## This file is processed with velocity
##
## SVG:
## +----------------> X-Axis
## |(0,0)
## |
## V 
##   Y-Axis
 */
/* === Definitions from velocity */
var itemId = '$data.itemId.toString()';
var itemIdEnc = '$TextTool.urlEncode($data.itemId.toString())';
var canvas = '$data.canvas';

// #set($apos="'") ## set a velocity variable

function fetchDataAndRender() {
	console.log("=== fetchDataAndRender");

	/* === Definitions */
	var width, height;
	var centerX, centerY;

	/* nodes are slightly inwards of the canvas */
	var marginX = 10;
	var marginY = 20;

	var minX;
	var maxX;
	var minY;
	var maxY;
	var frontMinX;
	var frontMaxX;
	var frontMinY;
	var frontMaxY;
	var offsetX = 50;

	var nodeRadius;
	var linkNormalWidth = $linkLineWidth;
	var markerWidth = linkNormalWidth;
	var markerHeight = linkNormalWidth;
	var linkDistance;
	// empirical
	var spacePerNode = 788 / 2; // (788 * 506) / 16; // max 28

	var forceFriction = 1;
	var forceGravity = 0.60; // 0.9
	var forceChargeDistance;// = 1000;
	var forceLinkStrength = 0.7;
	var forceCharge = -6000;

	var percentComplete = 0;
	var percentShowNodes;
	var percentShowLabels;
	var percentFreeze;

	/*
	 * take value, cut of values below valLow or higher than valHigh; take this
	 * bounded value and interpolate it linear to be in range [resultLow,
	 * resultHigh], mapped to [valLow,valHigh].
	 */
	function scaleLinear(value, valLow, valHigh, resultLow, resultHigh) {
		return resultLow + Math.min(valHigh, Math.max(0, value - valLow))
				/ valHigh * Math.abs(resultHigh - resultLow);
	}

	function init() {
		width = $("#d3").width(), height = Math.max(window.innerHeight - 250,
				width * 0.5);


		minX = marginX;
		minY = marginY;
		maxX = width - marginX;
		maxY = height - marginY;

		// move graph to the left, so that node labels fit better
		maxX -= offsetX;

		centerX = minX + ((maxX - minX) / 2);
		centerX = minY + ((maxY - minY) / 2);

		nodeRadius = Math.min(12, width / 70);
		
		frontMinX = 0 - nodeRadius;
		frontMinY = 0 - nodeRadius;
		frontMaxX = width + nodeRadius;
		frontMaxY = height + nodeRadius;

		var space = Math.min(width, height);
		if (maxNodes == -1) {

			// maxNodes = Math.round(space / spacePerNode);
			maxNodes = Math
					.round(scaleLinear(space, spacePerNode, 1300, 10, 30));

		}
		forceChargeDistance = Math.max(width, height) * 1.5;

		percentShowNodes = 0.3;
		percentShowLabels = 0.7;
		// for 23 nodes
		percentFreeze = 0.99;
	}

	var phase = 0;
	var updatePositions = false;

	/*
	 * === Helper functions
	 * ----------------------------------------------------------------------------------------------
	 */
	function sgn(x) {
		if (x > 0)
			return 1;
		else if (x < 0)
			return -1;
		else
			return 0;
	}

	function assert(cond, msg) {
		if (!cond) {
			console.warn("Assertion violated: " + msg);
		}
	}

	function contains(str, search) {
		return str && ("" + str).indexOf(search) >= 0;
	}

	/* estimate label length in pixels */
	// char [33, ..., 126]
	var charWidth = [ 3.3, 4.3, 6.7, 6.7, 10.7, 8, 2.3, 4, 4, 4.7, 7, 3.3, 4,
			3.3, 3.3, 6.7, 5.9, 6.7, 6.7, 6.7, 6.7, 6.7, 6.7, 6.7, 6.7, 3.3,
			3.3, 7, 7, 7, 6.7, 12.2, 8, 8, 8.7, 8.7, 8, 7.3, 9.3, 8.7, 3.3, 6,
			8, 6.7, 10, 8.7, 9.3, 8, 9.3, 8.7, 8, 7.3, 8.7, 8, 11.3, 8, 8, 7.3,
			3.3, 3.3, 3.3, 5.6, 6.7, 4, 6.7, 6.7, 6, 6.7, 6.7, 3.1, 6.7, 6.7,
			2.7, 2.7, 6, 2.7, 10, 6.7, 6.7, 6.7, 6.7, 4, 6, 3.3, 6.7, 6, 8.7,
			6, 6, 6, 4, 3.1, 4, 7 ];

	function approxCharWidth(c) {
		if (c < 33 || c > 126)
			return 6.7;
		return charWidth[c - 33];
	}

	function approxStringWidth(s) {
		var sum = 0;
		for (i = 0; i < s.length; i++) {
			var c = s.charCodeAt(i);
			sum += approxCharWidth(c);
		}
		return sum;
	}

	/* run --------------------------------------------------------------------- */
	init();

	var svg = d3.select('#d3') //
	.append('svg') //
	.attr('width', width)//
	.attr('height', height) //
	.attr("class", "palette2") //
	// .attr("viewBox","0,0,1000,1000")
	// .attr("preserveAspectRatio","none meet")
	// might be required for SVG serialisation only
	// xmlns = http://www.w3.org/XML/1998/namespace -- needs not to be declared
	// .attr("xmlns","http://www.w3.org/2000/svg") //
	// .attr("xmlns:xlink","http://www.w3.org/1999/xlink") //
	;

	/* === Define arrow markers */
	// Per-type markers, as they don't inherit styles.
	svg.append("defs").selectAll("marker").data([ //
	{
		id : "arrow0",
		stroke : linkNormalWidth
	}, //
	{
		id : "arrow1",
		stroke : linkNormalWidth
	}, //
	{
		id : "arrow2",
		stroke : linkNormalWidth
	}, //
	{
		id : "arrow3",
		stroke : linkNormalWidth
	}, //
	{
		id : "arrow4",
		stroke : linkNormalWidth
	}, //
	{
		id : "arrow5",
		stroke : linkNormalWidth
	}, //
	{
		id : "arrow6",
		stroke : linkNormalWidth
	}, //
	{
		id : "arrow7",
		stroke : linkNormalWidth
	} //
	]).enter().append("marker")//
	.attr("id", function(d) {
		return d["id"];
	})//
	.attr("viewBox", "0 0 10 10") //
	.attr("refX", 0)//
	.attr("refY", 5) //
	.attr("markerWidth", markerWidth).attr("markerHeight", markerHeight) //
	.attr("orient", "auto") //
	.append("path")//
	.attr("d", function(d) {
		var stroke = d['stroke'];
		return "M0,0L10,5L0,10";
	})//
	;

	/* === Define filters */
	// TODO use filter
	svg.select("defs").append("filter")//
	.attr("id", "filterBlur")//
	.append("feGaussianBlur")//
	.attr("stdDeviation", "5");

	/*
	 * We also need to update positions of the links. For those elements, the
	 * force layout sets the `source` and `target` properties, specifying `x`
	 * and `y` values in each case.
	 * 
	 * Here's where you can see how the force layout has changed the `source`
	 * and `target` properties of the links. Now that the layout has executed at
	 * least one iteration, the indices have been replaced by references to the
	 * node objects.
	 */
	function linkArc(d, i) {
		var sourceX = d.source.x;
		var sourceY = d.source.y;
		var targetX = d.target.x;
		var targetY = d.target.y;

		if (contains(d.source.class, "frontier")) {
			// swap source and target
			aX = sourceX;
			aY = sourceY;
			sourceX = targetX;
			sourceY = targetY;
			targetX = aX;
			targetY = aY;
		}

		var dx = targetX - sourceX;
		var dy = targetY - sourceY;
		// Pythagoras & "Strahlensatz": length of vector
		var f = Math.sqrt(dx * dx + dy * dy);
		if (f == 0) {
			return "";
			// f = 1;
		}

		/* Skip some pixel at source of node */
		var sourceF = nodeRadius / f;
		var sourceSkipX = dx * sourceF;
		var sourceSkipY = dy * sourceF;
		/* a = nodeRadius * x / sqrt(dx^2 + dy^2) */
		var sX = sourceX;// + sourceSkipX;
		var sY = sourceY;// + sourceSkipY;
		var tX;
		var tY;
		if (contains(d.source.class, "frontier")
				|| contains(d.target.class, "frontier")) {
			var ghostLineLength = nodeRadius + 30;
			var targetF = ghostLineLength / f;
			tX = sourceX + dx * targetF;
			tY = sourceY + dy * targetF;
		} else {
			/* normal skipping of some pixels in the target region */
			var targetF = (nodeRadius + $nodeCircleLineWidth + (3 * $linkLineWidth))
					/ f;
			var targetSkipX = dx * targetF;
			var targetSkipY = dy * targetF;
			// don't draw in the circles, adjust source and target
			tX = targetX - targetSkipX;
			tY = targetY - targetSkipY;
		}

		return "M" + sX + "," + sY + "L" + tX + "," + tY;
	}

	function goToId(d) {
		var x = d3.select(this).attr("data-xid");
		var xEnc = encodeURIComponent(x);

		/*
		 * #set($xxx = $data.router.url_item('xxx') )##
		 * 
		 * .## the following must remain a single line
		 */

		var urlTemplate = $apos$xxx$apos;
		var url = urlTemplate.replace('xxx', xEnc);
		url = url + '?canvas=' + canvas + '$maxNodesParam' + '$maxDepthParam';

		/* #if(false)## */
		// fake for js parser
		if (x)
			x = 3;
		/* #end */

		console.log("goToId " + url);
		window.location = url;
	}

	function dragstart(d) {
		/*
		 * remember starting position so that we can later distinguish a click
		 * and a drag
		 */
		d.dragStartX = d.x;
		d.dragStartY = d.y;
	}

	function dragend(d) {
		var alphaBefore = force.alpha();
		var dist = Math.abs(d.dragStartX - d.x) + Math.abs(d.dragStartY - d.y);
		if (dist < 5) {
			if (d.fixed) {
				d3.select(this).classed("fixed", false);
				d.prepareUnfix = true;
			}
		} else {
			d3.select(this).classed("fixed", true);
			d.fixed = true;
		}
		force.alpha(alphaBefore);
	}

	function unfreeze() {
		phase = 0;
		force.alpha(0.03);
		console.log("unfreeze")
	}

	function mouseout(d) {
		if (d.prepareUnfix == true) {
			d.prepareUnfix = false;
			d.fixed = false;
			if (percentComplete <= percentFreeze) {
				unfreeze();
			}
		}
	}

	/*
	 * === Once: Get JSON data an construct graph
	 * ---------------------------------------------------------------------
	 */

	var force;
	var nodes, node;
	var links, link;
	var frontierLinks = [];
	var frontierNodes = [];

	/** labelOffset = "60%" by default */
	function appendLink(parent, id, x1, y1, x2, y2, classes, label, typenumber,
			labelOffset) {
		if (!typenumber) {
			typenumber = 0;
		}
		if (!labelOffset) {
			labelOffset = "60%";
		}
		if (!classes) {
			classes = "";
		}

		parent.classed("link disable-select " + "type" + typenumber + " "
				+ classes, true);

		var path = parent.append('path')//
		.attr('id', id);
		//

		if (!parent.classed("frontier")) {
			path.attr("marker-end", "url(#arrow" + typenumber + ")")//
		}

		if (x1) {
			path.attr("d", "M" + x1 + "," + y1 + "L" + x2 + "," + y2);
		}

		if (!parent.classed("frontier")) {

			parent.append("text")//
			.attr("class", "linklabel shadow")//
			// -2 = above line, 3 = in line
			.attr("dy", "3")//
			.append("textPath")//
			.attr("xlink:href", "#" + id) //
			// 60% because links start in center of circle but
			// stop before marker begins
			.attr("startOffset", labelOffset).text(label)//
			;

			parent.append("text")//
			.attr("class", "linklabel")//
			// -2 = above line, 3 = in line
			.attr("dy", "3")//
			.append("textPath")//
			.attr("xlink:href", "#" + id) //
			// 60% because links start in center of circle but
			// stop before marker begins
			.attr("startOffset", labelOffset).text(label)//
			;

		}
	}

	function buildGraph(error, graph) {
		// Extract the nodes and links from the data.
		var captions = graph.captions;
		nodes = graph.nodes;
		var hideFrontierLinks = false;
		if (hideFrontierLinks) {
			links = [];
			for (i = 0; i < graph.links.length; i++) {
				var llink = graph.links[i];
				if (contains(llink["class"], "frontier")) {
					frontierLinks.push(llink);
				} else {
					links.push(llink);
				}
			}
		} else {
			links = graph.links;
		}

		// move in range 0.7 (7 nodes or less) to 0.97 (more
		// than 30 nodes)
		percentFreeze = scaleLinear(nodes.length, 7, 30, 0.7, 0.999);
		// percentShowLabels = scaleLinear(nodes.length, 7, 30,
		// 0.7, percentFreeze);
		// percentShowNodes = scaleLinear(nodes.length, 7, 30,
		// 0.2,
		// percentShowLabels/2);

		percentShowLabels = 0.15;
		percentShowNodes = percentShowLabels;

		console.log("ShowNodes " + percentShowNodes + " ShowLabels "
				+ percentShowLabels + " Freeze " + percentFreeze);

		/*
		 * Create a force layout object and define its properties. Those include
		 * the dimensions of the visualization and the arrays of nodes and
		 * links.
		 */
		force = d3.layout.force() //
		.size([ width, height ]) //
		.nodes(nodes) //
		.links(links) //
		;
		force.friction(forceFriction);
		force.gravity(forceGravity);
		force.chargeDistance(forceChargeDistance);
		// default 0.8; 1 = faster, less quality of force; 0 =
		// dont approximate at all
		force.theta(0);

		/*
		 * linkDistance === This parameter defines the distance (normally in
		 * pixels) that we'd like to have between nodes that are connected. (It
		 * is, thus, the length we'd like our links to have.)
		 */
		force.linkDistance(function(d, i) {
			var label = links[i]["label"];
			// depends on font size and text styling
			var estimation = approxStringWidth(label) * 1.7;
			return estimation;
		});
		force.linkStrength(function(d) {
			if (contains(d.class, "frontier")) {
				return 0;
			} else {
				return forceLinkStrength;
			}
		});

		/* charge */
		force.charge(function(d) {
			if (contains(d.class, "frontier")) {
				return 0;
			} else {
				return forceCharge;
			}
		});

		/* === set up event listeners */
		var drag = force.drag() //
		.on("dragstart", dragstart) //
		.on("dragend", dragend) //
		;

		/*
		 * === Captions
		 * -------------------------------------------------------------------------
		 */
		// copy data from JSON to SVG
		var captionG = svg.append("g").attr("class", "captions");

		var captionOffsetX = 16;
		var captionOffsetY = 16;
		var captionLineHeight = 24;
		
		var captionPosY = captionOffsetY;

		/* determine how wide the captions need to be */
		var captionLinkLabelMaxLength = 150;
		captions.forEach(function(caption, i) {
			if (caption.type == "link") {
				var labelLen = approxStringWidth(caption.label);
				console.log("len=" + labelLen + " for " + caption.label);
				captionLinkLabelMaxLength = Math.max(captionLinkLabelMaxLength,
						1.2 * labelLen);
			}
		});
		captionLinkLabelMaxLength += 0;

		captions.forEach(function(d, i) {
			var caption = d;

			var captionElement = captionG.append("g")//
			.on("click", goToId)
			//
			.attr("data-xid", function(d, i) {
				return caption['xid'];
			}) //
			.attr("class",
					"caption" + caption['type'] + " disable-select type"
							+ caption['typenumber']);
			if (caption.type == "node") {
				captionElement.classed("node", true)//
				.attr("cx", captionOffsetX)	//
				.attr("cy", captionPosY)//
				.attr("transform",	"translate(" + (captionOffsetX) + "," + (captionPosY) + ")"); 
				
				captionElement.append('circle') //
				.attr("class", "circle") //
				.attr('r', nodeRadius); //
				
				var captionLines = caption.labels;
				
				for(i = 0; i < captionLines.length; i++) {
					captionLine = captionLines[i];
					captionElement.append("text") //
					.attr("dx", 13) //
					.attr("dy", 6 + i * captionLineHeight)// ".35em"
					.text(captionLine);
				}
				captionPosY += (i-1) * captionLineHeight+6;
			} else {
				assert(caption.type == "link");
				appendLink(captionElement, "caption" + i, 1, captionPosY,
						captionLinkLabelMaxLength, captionPosY, "",
						caption.label, caption.typenumber, "50%");
			}
			captionPosY += 30;
		});

		/*
		 * Next we'll add the nodes and links to the visualization. Note that
		 * we're just sticking them into the SVG container at this point. We
		 * start with the links. The order here is important because we want the
		 * nodes to appear "on top of" the links. SVG doesn't really have a
		 * convenient equivalent to HTML's `z-index`; instead it relies on the
		 * order of the elements in the markup. By adding the nodes _after_ the
		 * links we ensure that nodes appear on top of links.
		 */
		/*
		 * Links are pretty simple. They're just SVG lines. We're going to
		 * position the lines according to the centers of their source and
		 * target nodes. You'll note that the `source` and `target` properties
		 * are indices into the `nodes` array. That's how our JSON is structured
		 * and that's how D3's force layout expects its inputs. As soon as the
		 * layout begins executing, however, it's going to replace those
		 * properties with references to the actual node objects instead of
		 * indices.
		 */
		var linkContainer = svg.append("g").attr("class", "links");
		link = linkContainer.selectAll('.link').data(links).enter()//
		.append('g');

		link.each(function(d, i) {
			appendLink(d3.select(this), "linkid" + i, nodes[d.source].x,
					nodes[d.source].y, nodes[d.target].x, nodes[d.target].y,
					d['class'], d.label, d.typenumber);
		});

		link.attr("data-xid", function(d, i) {
			return d.xid;
		})//
		.on("click", goToId)//
		;

		/*
		 * Each node is drawn as a circle and given a radius and initial
		 * position within the SVG container. As is normal with SVG circles, the
		 * position is specified by the `cx` and `cy` attributes (works only on
		 * circles!), which define the center of the circle. We actually don't
		 * have to position the nodes to start off, as the force layout is going
		 * to immediately move them. But this makes it a little easier to see
		 * what's going on before we start the layout executing.
		 */
		node = svg.append("g").attr("class", "nodes").selectAll(".node").data(
				nodes).enter().append("g")//

		.on("dblclick", goToId) //
		.on("mouseout", mouseout)
		.attr("style", function(d, i) {
			var local = nodes[i]["style"];
			if (local) {
				return local;
			} else {
				return null;
			}
		}).attr("data-xid", function(d, i) {
			return nodes[i].xid;
		}) //
		.attr('cx', function(d, i) {
			return d.x;
		})//
		.attr('cy', function(d, i) {
			return d.y;
		})//
		.attr("class", function(d, i) {
			var typenumber = d.typenumber;
			if (!typenumber) {
				typenumber = 0;
			}

			var c = "node disable-select";
			var local = nodes[i]["class"];
			if (local) {
				c += " " + local;
			}
			/* fix center node initially */
			if (i == 0) {
				// set to center position
				d.x = centerX;
				d.y = centerY;
				c += " center fixed";
				d.fixed = true;
			}

			return c + " node type" + typenumber;
		})//
		.call(force.drag);

		node.append("title").text(function(d, i) {
			return nodes[i].xid;
		})//

		node.append('circle') //
		.attr("class", "circle") //
		.attr('r', nodeRadius); //

		// IMPROVE how to put an image in the circle
		// .append("image").attr("xlink:href",
		// "https://github.com/favicon.ico").attr(
		// "x", -8).attr("y", -8).attr("width",
		// 16).attr("height",
		// 16);

		node.append("text") //
		.attr("dx", 13) //
		.attr("dy", ".35em").text(function(d) {
			return d.label;
		});

		// Next we define a function that executes at each
		// iteration of the force layout.
		force.on('tick', tick);

		// function forwardAlpha(layout, alpha, max) {
		// alpha = alpha || 0;
		// max = max || 1000;
		// var i = 0;
		// while(layout.alpha() > alpha && i++ < max)
		// layout.tick();
		// }

		// run the force directed layout with visible animation
		force.start();

		// $(window).resize(function() {
		// init();
		// });

	}

	function addFrontierNodesAndLinks() {

	}

	/*
	 * === Loop: Run gazillion times
	 * -------------------------------------------------------------------------------------------------------------------
	 */

	var iteration = 0;
	var mode = "initial";

	function tick() {
		iteration++;
		console.log(">> tick " + iteration + " alpha=" + force.alpha() + "="
				+ percentComplete + "% complete phase=" + phase);

		/*
		 * When this function executes, the force layout calculations have been
		 * updated. The layout will have set various properties in our nodes and
		 * links objects that we can use to position them within the SVG
		 * container.
		 * 
		 * First let's reposition the nodes. As the force layout runs it updates
		 * the `x` and `y` properties that define where the node should be
		 * centered. To move the node, we set the appropriate SVG attributes to
		 * their new values.
		 */

		// distance from center
		// var maxDistX = 0, maxDistY = 0;
		// alpha starts at 0.1 and goes to
		// 0; non-linear;
		// percentComplete [0,1]
		percentComplete = scaleLinear(0.1 - force.alpha(), 0, 0.1, 0, 1);
		assert(percentShowLabels <= percentFreeze, "%showLabels="
				+ percentShowLabels + " <= %freeze=" + percentFreeze);
		var opacity;
		var opacityChanged = false;
		var phaseChanged = false;
		var updatePositionsNow = false;
		/* initial phase */
		if (mode == "initial") {
			if (phase == 0) {
				phase = 1;
				// hide most stuff, faster
				opacity = "display: none;";
				opacityChanged = true;
				updatePositions = false;
				console.log("Labels hidden at " + percentComplete
						+ "% complete");
			}
			if (phase == 1 && percentComplete >= percentShowNodes) {
				phaseChanged = true;
				phase = 2;
				updatePositions = true;
				console.log("Show nodes at " + percentComplete + "% complete");
			}
			if (phase == 2 && percentComplete >= percentShowLabels) {
				phaseChanged = true;
				phase = 3;
				updatePositions = true;
				console.log("Show labels at " + percentComplete + "% complete");
				var o = 0.7;
				opacity = "stroke-opacity: " + o + ";"// 
						+ "fill-opacity: " + o + ";" + "opacity: " + o + ";"
				opacityChanged = true;
			}
		}
		if (phase == 3
				&& (percentComplete >= percentFreeze || force.alpha() <= 0.051)) {
			phaseChanged = true;
			phase = 4;
			updatePositions = true;
			console.log("Freeze at " + percentComplete + "% complete");
			// freeze movement
			addFrontierNodesAndLinks();
			opacity = " ";
			opacityChanged = true;
			force.alpha(0);
			mode = "dragdrop";
		}
		if (phase == 4 && percentComplete < 1) {
			phaseChanged = true;
			phase = 3;
		}

		if (opacityChanged) {
			node.select('text').attr("style", opacity);
			link.select("text").attr("style", opacity)//
			link.attr("style", opacity)//
		}

		/* slightly move source above target */
		links.forEach(function(d, i) {

			if (contains(d["class"], "frontier")) {
				return;
			}

			var s = d.source;
			var t = d.target;

			if (s.y < t.y) {
				// fine;
			} else {
				s.y -= 1;
				t.y += 1;
			}
		});

		/* push nodes away from edges */
		var k = 20 * force.alpha();
		nodes.forEach(function(d, i) {
			// 0..centerX (or even more, if
			// outside rectangle)
			var distX = Math.abs(d.x - centerX);
			// maxDistX = Math.max(distX,
			// maxX);

			var distY = Math.abs(d.y - centerY);
			// maxDistY = Math.max(distY,
			// maxY);

			if (contains(d["class"], "frontier")) {

				/**
				 * <pre>
				 * 
				 * \  1. / 
				 *  \ | /  
				 * 4--+-- 2. 
				 *  / | \ 
				 * / 3.  \
				 * </pre>
				 */

				var is12 = d.x > d.y;
				var is23 = maxY*d.x + maxX*d.y > maxX * maxY;
				
				if (is12 && !is23) {
					// 1
					console.log("1.");
					d.y = frontMinY;
				} else if (is12 && is23) {
					// 2.
					console.log("2.");
					d.x = frontMaxX;
				} else if (!is12 && is23) {
					// 3.
					console.log("3.");
					d.y = frontMaxY;
				} else if (!is12 && !is23) {
					// 4.
					console.log("4.");
					d.x = frontMinX;
				}

			} else {
				if (d.x < minX) {
					d.x += ((minX - d.x) * k);
				}
				if (d.x > maxX) {
					d.x += ((maxX - d.x) * k);
				}
				if (d.y < minY) {
					d.y += ((minY - d.y) * k);
				}
				if (d.y > maxY) {
					d.y += ((maxY - d.y) * k);
				}
			}
		});

		if (mode == "dragdrop") {
			updatePositionsNow = true;
			// cool down some more
			force.alpha(force.alpha() * 0.995);
		} else {
			assert(mode == "initial", "unknown mode: " + mode);
			if (phaseChanged) {
				updatePositionsNow = true;
			} else {
				updatePositionsNow = iteration % 100 == 0;
			}
		}

		if (updatePositionsNow) {
			console.log("update positions");
			node.attr("transform", function(d, i) {
				return "translate(" + (d.x) + "," + (d.y) + ")";
			}) //
			link.select("path")//
			.attr("d", linkArc)//
			;
		}

		// auto-adjust charge -------------
		// // use at least 80%
		// if (centerX * 0.9 > maxX &&
		// centerY * 0.9 > maxY
		// && force.charge() > -10000) {
		// force.charge(1.05 *
		// force.charge());
		// //XXX
		// force.linkDistance(force.linkDistance()
		// *
		// 1.005);
		// // console.log("new charge is " +
		// force.charge());
		// force.start();
		//
		// } else if ((centerX < maxX ||
		// centerY < maxY) &&
		// force.charge() >
		// -20) {
		// // force.charge(0.95 *
		// force.charge());
		// //XXX
		// force.linkDistance(force.linkDistance()
		// *
		// 0.99);
		// // console.log("new charge is " +
		// force.charge());
		// force.start();
		//
		// } else {
		// // console.log("maxX=" + maxX + "
		// maxY=" + maxY + "
		// // charge: "
		// // + force.charge());
		// }

	}

	// fetch data as JSON and buildGraph from it
	var jsonUrl = '/ext/d3.json?itemId=' + itemIdEnc 
	+ '&canvas=' + canvas
	+ '&maxNodes=' + maxNodes 
	+ '$maxDepthParam'
	;
	d3.json(jsonUrl, buildGraph);

}

fetchDataAndRender();

// $(window).resize(function() {
// console.log("Resize");
// $('#d3 svg').remove();
// layout();
// });

// end d3
// =================================================================================================
