package com.calpano.common.shared.xydrautils.field;

import java.util.SortedSet;
import java.util.TreeSet;

import org.xydra.base.BaseRuntime;
import org.xydra.base.XId;
import org.xydra.base.value.XIdSortedSetValue;

public class XIDSortedSetFieldProperty extends
		ExtensibleFieldProperty<SortedSet<XId>, XIdSortedSetValue> {

	public XIDSortedSetFieldProperty(final String fieldIdString) {
		super(fieldIdString, new Converter<SortedSet<XId>, XIdSortedSetValue>() {

			@Override
			public SortedSet<XId> toJavaType(final XIdSortedSetValue xydraType) {
				if (xydraType == null) {
					return new TreeSet<XId>();
				} else {
					return xydraType.toSortedSet();
				}
			}

			@Override
			public XIdSortedSetValue toXydraValue(final SortedSet<XId> anyType) {
				return BaseRuntime.getValueFactory().createIdSortedSetValue(anyType);
			}
		});
	}

}
