package com.calpano.common.shared.xydrautils.field;

import org.xydra.base.BaseRuntime;
import org.xydra.base.value.XLongValue;

import de.xam.p13n.shared.time.MiniDateTime;

public class DateTimeFieldProperty extends ExtensibleFieldProperty<MiniDateTime, XLongValue> {

	private static final Converter<MiniDateTime, XLongValue> CONVERTER = new Converter<MiniDateTime, XLongValue>() {

		@Override
		public MiniDateTime toJavaType(final XLongValue xydraType) {
			if (xydraType == null) {
				return null;
			} else {
				return new MiniDateTime(xydraType.contents());
			}
		}

		/**
		 * @param anyType
		 *            should be in UTC timezone
		 * @return ...
		 */
		@Override
		public XLongValue toXydraValue(final MiniDateTime anyType) {
			return BaseRuntime.getValueFactory().createLongValue(anyType.getMillis());
		}

	};

	public DateTimeFieldProperty(final String fieldIdString) {
		super(fieldIdString, CONVERTER);
	}

}
