package com.calpano.common.shared.xydrautils.field;

import org.xydra.base.Base;
import org.xydra.base.XId;
import org.xydra.base.rmof.XReadableField;
import org.xydra.base.rmof.XReadableObject;
import org.xydra.base.rmof.XWritableObject;
import org.xydra.base.value.XBooleanValue;
import org.xydra.base.value.XValue;

/**
 * Model a true as the existence of a field and a false as the absence. Much
 * faster than other approaches.
 *
 * TODO What is the difference from this to FieldProperty<Boolean>?
 *
 * @author xamde
 */
public class BooleanFieldProperty {

	private final XId fieldId;

	public BooleanFieldProperty(final String fieldIdString) {
		this.fieldId = Base.toId(fieldIdString);
	}

	/**
	 * @param xo
	 *            from which to read
	 * @return the stored value of the field as boolean
	 */
	public boolean getValue(final XReadableObject xo) {
		assert xo != null : "xo was null";
		assert this.fieldId != null;
		final boolean b = xo.hasField(this.fieldId);
		if (!b) {
			return b;
		} else {
			// backwards compatibility with FieldProperty<Boolean>
			final XReadableField field = xo.getField(this.fieldId);
			final XValue value = field.getValue();
			if (value == null) {
				return true;
			}
			return ((XBooleanValue) value).contents();
		}
	}

	/**
	 * Set the value of this field within XObject xo to the given value of java
	 * type <J>
	 *
	 * @param actorId
	 *            used to set the value
	 * @param xo
	 *            where to write
	 * @param javaValue
	 *            which Java value to write
	 */
	public void setValue(final XId actorId, final XWritableObject xo, final boolean javaValue) {
		if (javaValue == false) {
			if (xo.hasField(this.fieldId)) {
				xo.removeField(this.fieldId);
			}
		} else {
			assert javaValue == true;
			if (!xo.hasField(this.fieldId)) {
				xo.createField(this.fieldId);
			}
		}
	}

	public XId getFieldId() {
		return this.fieldId;
	}

}
