package com.calpano.common.shared.xydrautils;

import java.util.Iterator;

import org.xydra.base.XAddress;
import org.xydra.base.XId;
import org.xydra.base.XType;
import org.xydra.base.rmof.XWritableField;
import org.xydra.base.rmof.XWritableObject;
import org.xydra.base.value.XValue;
import org.xydra.core.index.IBasicUniqueObjectIndex;
import org.xydra.core.index.impl.memory.IndexUtils;

/**
 * @deprecated Might work fine. Not used.
 */
@Deprecated
public class ObjectAsIndex implements XWritableObject, IBasicUniqueObjectIndex {

	@Override
	public XAddress getAddress() {
		return this.baseObject.getAddress();
	}

	@Override
	public XId getId() {
		return this.baseObject.getId();
	}

	@Override
	public XWritableField createField(final XId fieldId) {
		return this.baseObject.createField(fieldId);
	}

	@Override
	public long getRevisionNumber() {
		return this.baseObject.getRevisionNumber();
	}

	@Override
	public XWritableField getField(final XId fieldId) {
		return this.baseObject.getField(fieldId);
	}

	@Override
	public boolean removeField(final XId fieldId) {
		return this.baseObject.removeField(fieldId);
	}

	@Override
	public boolean hasField(final XId fieldId) {
		return this.baseObject.hasField(fieldId);
	}

	@Override
	public boolean isEmpty() {
		return this.baseObject.isEmpty();
	}

	@Override
	public Iterator<XId> iterator() {
		return this.baseObject.iterator();
	}

	private XWritableObject baseObject;

	/* Just for GWT */
	protected ObjectAsIndex() {
	}

	public ObjectAsIndex(final XWritableObject baseObject) {
		this.baseObject = baseObject;
	}

	/**
	 * Index method.
	 *
	 * @param indexKey
	 *            to be looked up
	 * @return the currently indexed XID or null if none found.
	 */
	@Override
	public XId lookupID(final XValue indexKey) {
		assert indexKey != null;
		final XId key = IndexUtils.valueToXId(indexKey);
		final XWritableField indexField = getField(key);
		if (indexField == null) {
			return null;
		}
		final XId indexValue = (XId) indexField.getValue();
		assert indexValue != null;
		return indexValue;
	}

	/**
	 * Index method.
	 *
	 * @param key
	 *            to be indexed
	 * @param value
	 *            to be indexed
	 * @return the previously indexed value, if any, or null.
	 */
	@Override
	public XId index(final XValue key, final XId value) {
		if (key == null) {
			throw new IllegalArgumentException("key may not be null");
		}
		if (value == null) {
			throw new IllegalArgumentException("value may not be null");
		}
		final XId xid = IndexUtils.valueToXId(key);
		final XWritableField indexField = createField(xid);
		final XId indexValue = (XId) indexField.getValue();
		XId previous;
		if (indexValue == null) {
			previous = null;
		} else {
			previous = indexValue;
		}
		indexField.setValue(value);
		return previous;
	}

	/**
	 * Index method.
	 *
	 * @param indexKey
	 *            never null
	 * @return true if index contains the given key
	 */
	@Override
	public boolean contains(final XValue indexKey) {
		assert indexKey != null;
		final XId key = IndexUtils.valueToXId(indexKey);
		assert key != null;
		final XWritableField indexField = getField(key);
		if (indexField == null) {
			return false;
		}
		return true;
	}

	/**
	 * Index method.
	 *
	 * @param key
	 *            to de-index
	 * @return the previously indexed XID or null of not found
	 */
	@Override
	public XId deindex(final XValue key) {
		assert key != null;
		final XId xid = IndexUtils.valueToXId(key);
		final XWritableField indexField = getField(xid);
		if (indexField == null) {
			// nothing to do to deindex
			return null;
		}
		final XId indexValue = (XId) indexField.getValue();
		assert indexValue != null : "IndexField " + indexField.getId()
				+ " has a null value. Key = " + key;
		final XId previous = indexValue;
		removeField(xid);
		return previous;
	}

	@Override
	public XType getType() {
		return XType.XOBJECT;
	}

}
