package com.calpano.common.shared.xydrautils;

import org.xydra.base.XId;
import org.xydra.base.rmof.XWritableField;
import org.xydra.base.rmof.XWritableObject;
import org.xydra.base.value.XValue;
import org.xydra.core.index.IBasicUniqueObjectIndex;
import org.xydra.core.index.impl.memory.IndexUtils;

/**
 * @deprecated Might work fine. Not used.
 */
@Deprecated
public class IndexAccess implements IBasicUniqueObjectIndex {

	private transient XWritableObject baseObject;

	public IndexAccess(final XWritableObject xo) {
		this.baseObject = xo;
	}

	/**
	 * Index method.
	 *
	 * @param indexKey
	 *            to be looked up
	 * @return the currently indexed XID or null if none found.
	 */
	@Override
	public XId lookupID(final XValue indexKey) {
		assert indexKey != null;
		final XId key = IndexUtils.valueToXId(indexKey);
		final XWritableField indexField = getXObject().getField(key);
		if (indexField == null) {
			return null;
		}
		final XId indexValue = (XId) indexField.getValue();
		assert indexValue != null;
		return indexValue;
	}

	private synchronized XWritableObject getXObject() {
		return this.baseObject;
	}

	/**
	 * Index method.
	 *
	 * @param key
	 *            to be indexed
	 * @param value
	 *            to be indexed
	 * @return the previously indexed value, if any, or null.
	 */
	@Override
	public XId index(final XValue key, final XId value) {
		if (key == null) {
			throw new IllegalArgumentException("key may not be null");
		}
		if (value == null) {
			throw new IllegalArgumentException("value may not be null");
		}
		if (value.toString().length() == 0) {
			throw new IllegalArgumentException("value has zero-length");
		}
		final XId xid = IndexUtils.valueToXId(key);
		final XWritableField indexField = getXObject().createField(xid);
		final XId indexValue = (XId) indexField.getValue();
		XId previous;
		if (indexValue == null) {
			previous = null;
		} else {
			previous = indexValue;
		}
		indexField.setValue(value);
		return previous;
	}

	/**
	 * Index method.
	 *
	 * @param indexKey
	 *            never null
	 * @return true if index contains the given key
	 */
	@Override
	public boolean contains(final XValue indexKey) {
		assert indexKey != null;
		final XId key = IndexUtils.valueToXId(indexKey);
		assert key != null;
		final XWritableField indexField = getXObject().getField(key);
		if (indexField == null) {
			return false;
		}
		return true;
	}

	/**
	 * Index method.
	 *
	 * @param key
	 *            to de-index
	 * @return the previously indexed XID or null of not found
	 */
	@Override
	public XId deindex(final XValue key) {
		assert key != null;
		final XId xid = IndexUtils.valueToXId(key);
		final XWritableField indexField = getXObject().getField(xid);
		if (indexField == null) {
			// nothing to do to deindex
			return null;
		}
		final XId indexValue = (XId) indexField.getValue();
		assert indexValue != null : "IndexField " + indexField.getId()
				+ " has a null value. Key = " + key;
		final XId previous = indexValue;
		getXObject().removeField(xid);
		return previous;
	}

}
