package com.calpano.common.shared.xydrautils;

import org.xydra.annotations.NeverNull;
import org.xydra.annotations.Template;
import org.xydra.base.XAddress;
import org.xydra.base.XId;
import org.xydra.base.rmof.XReadableObject;
import org.xydra.base.rmof.XWritableObject;

/**
 * Persistence is based on an {@link XWritableObject}
 *
 * @author xamde
 */
public interface IBasedOnXReadableObject extends IBasedOnXReadableEntity {

	/**
	 * @return the XID of the underlying {@link XWritableObject}
	 */
	@Template("Unique ID")
	@Override
	@NeverNull
	XId getId();

	/**
	 * @return the {@link XAddress} of the underlying {@link XWritableObject}
	 */
	@Override
	@NeverNull
	XAddress getAddress();

	/**
	 * @return the underlying {@link XReadableObject} itself
	 */
	XReadableObject getXObject();

}
