package com.calpano.common.shared.validation;

import org.xydra.annotations.NeverNull;

/**
 * Can compute the validity status of a given object of type T
 *
 * @param <T>
 *            object type to be validated
 */
public interface IValidator<T> {

	/**
	 * @param type
	 *            @NeverNull
	 * @return the {@link ValidationMessage} that results from inspecting the
	 *         given widget
	 */
	ValidationMessage computeValidation(@NeverNull T type);

}
