package com.calpano.common.shared.util;

import java.net.Socket;

import org.xydra.annotations.RunsInAppEngine;
import org.xydra.annotations.RunsInGWT;
import org.xydra.annotations.Setting;
import org.xydra.env.Env;

/**
 * This class is gwt-super-sourced.
 *
 * Provides basic information about GWT isself.
 *
 * @author xamde
 */
@RunsInGWT(true)
@RunsInAppEngine(true)
public class AboutGwt_Emul {

	@Setting("AboutAppEngine.inProduction")
	public static boolean isDevMode() {

		if (Env.get().conf().getBoolean("AboutAppEngine.inProduction")) {
			return false;
		}

		// check if devmode server is running
		return canOpenSocketToPortOnLocalhost(GwtConstants.GWT_DEV_MODE_PORT);
	}

	/**
	 * This code does not run on AppEngine. Neither in GWT.
	 *
	 * @param port
	 * @return true if we can connect to the given port
	 */
	@RunsInGWT(false)
	@RunsInAppEngine(false)
	public static boolean canOpenSocketToPortOnLocalhost(final int port) {
		// String urlStr = "127.0.0.1:" + port;
		// try {
		// URL url = new URL(urlStr);
		// InputStreamReader in = new
		// InputStreamReader(url.openStream(),"UTF-8");
		// return true;
		// } catch (Exception e) {
		// return false;
		// }
		// UniversalUrlFetch.callUrl("127.0.0.1:"+port, null, null, false);

		boolean result;
		try {
			final Socket serverSocket = new Socket("127.0.0.1", port);
			result = true;
			serverSocket.close();
		} catch (final Exception e) {
			result = false;
		}
		return result;
	}

}
