package com.calpano.common.shared.user.wrapper;

import org.xydra.annotations.Template;

import com.calpano.common.shared.user.AccountState;
import com.calpano.common.shared.xydrautils.IBasedOnXWritableObject;
import com.calpano.common.shared.xydrautils.field.BooleanFieldProperty;
import com.calpano.common.shared.xydrautils.field.EnumFieldProperty;
import com.calpano.common.shared.xydrautils.field.FieldProperty;
import com.calpano.common.shared.xydrautils.impl.BasedOnXWritableObject;

import de.xam.p13n.shared.Personalisation;

public class CoreUser extends BasedOnXWritableObject implements IBasedOnXWritableObject {

	/** lazy initialised. See {@link #getPersonalisation()} */
	private static FieldProperty<String> _p13n = new FieldProperty<String>("p13n", String.class);

	/** always initialised. See {@link #isRegistered()} */
	private static EnumFieldProperty<AccountState> _accountState = new EnumFieldProperty<AccountState>(
			"acountState", AccountState.class);

	private static final BooleanFieldProperty _useBeta = new BooleanFieldProperty("_useBeta");

	public CoreUser(final IBasedOnXWritableObject proto) {
		super(proto);
	}

	private static final long serialVersionUID = 1L;

	/**
	 * @return the {@link Personalisation} of the user or null if the user has
	 *         none
	 */
	@Template("personalisation")
	public Personalisation getPersonalisation() {
		final String compactString = _p13n.getValue(getXObject());
		final Personalisation p13n = Personalisation.fromString(compactString);
		return p13n;
	}

	public void setPersonalisation(final Personalisation personalisation) {
		_p13n.setValue(getActorId(), getXObject(), personalisation.toCompactString());
	}

	public AccountState getAccountState() {
		final AccountState as = _accountState.getValue(getXObject());
		// was an old user
		if (as == null) {
			return AccountState.adminCreated;
		}
		return as;
	}

	/**
	 * @return true if user is willing to try out beta features
	 */
	public boolean getUseBeta() {
		return _useBeta.getValue(getXObject());
	}

	/**
	 * Set the value for {@link #getAccountState()}
	 *
	 * @param accountState
	 *            e.g. if user has registered an account, or if user object
	 *            exists only for tracking purposes
	 */
	public void setAccountState(final AccountState accountState) {
		_accountState.setValue(getActorId(), getXObject(), accountState);
	}

	/**
	 * @param useBeta
	 *            true if user is willing to try out beta features
	 */
	public void setUseBeta(final boolean useBeta) {
		_useBeta.setValue(getActorId(), getXObject(), useBeta);
	}

}
