package com.calpano.common.shared.user.base;

import java.io.Serializable;

import org.xydra.annotations.NeverNull;
import org.xydra.annotations.RunsInGWT;
import org.xydra.base.XId;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

import com.calpano.common.shared.user.INameEmailUser;

/**
 * An in-memory user with Id plus a name-email-pair.
 *
 * @author xamde
 */
@RunsInGWT(true)
public class SimpleNameEmailUser extends SimpleNameEmail implements INameEmailUser, Serializable {

	@SuppressWarnings("unused")
	private static final Logger log = LoggerFactory.getLogger(SimpleNameEmailUser.class);

	private static final long serialVersionUID = -1395697742640364489L;

	private @NeverNull XId id;

	/** Just for GWT */
	@SuppressWarnings("unused")
	private SimpleNameEmailUser() {
		super();
	}

	public SimpleNameEmailUser(final XId id, final String name, @NeverNull final String email) {
		super(name, email);
		this.id = id;
	}

	@Override
	public boolean equals(final Object other) {
		return other instanceof INameEmailUser && ((INameEmailUser) other).getId().equals(this.id);
	}

	@Override
	public @NeverNull XId getId() {
		return this.id;
	}

	@Override
	public int hashCode() {
		return this.id.hashCode();
	}

}
