package com.calpano.common.shared.user;

import java.io.Serializable;

import org.xydra.annotations.CanBeNull;
import org.xydra.annotations.Indexed;
import org.xydra.annotations.RunsInGWT;
import org.xydra.annotations.Security;
import org.xydra.annotations.Template;

/**
 * A simple readable user object for usage everywhere in GWT guis, velocity
 * templates or elsewhere.
 *
 * @author xamde
 */
@RunsInGWT(true)
public interface INameEmail extends Serializable {

	/**
	 * Result is <em>not</em> HTML-Safe.
	 *
	 * @return the real world name of the user, e.g. 'John Doe' or null if none
	 *         is defined
	 */
	@CanBeNull
	@Security("unsafe")
	@Template("Full name of user - raw")
	String getName();

	/**
	 * Result is <em>not</em> HTML-Safe.
	 *
	 * @return the email of the user (the address part only). In most settings
	 *         not null, but sometimes it is null.
	 */
	@CanBeNull
	@Indexed("server")
	@Template("email address, unverified, unchecked, not HTML-safe - but lower-cased")
	@Security("unsafe")
	String getEmail();

	/**
	 * @return the name if defined, otherwise the email, so it might also be
	 *         null.
	 */
	@Template("real world name (or email if no name is given)")
	@Security("unsafe")
	String getNameOrEmail();

	/**
	 * @return either 'name (email)' or if no name defined just 'email'
	 */
	@Security("unsafe")
	String getNameAndEmail();

}
