package com.calpano.common.shared.user;

import org.xydra.base.XId;

public interface IForwardUser extends IViralUser {

	/**
	 * @return an XID of an offer or null if none is set
	 */
	XId getOfferId();

	/**
	 * Internal.
	 *
	 * @param offerId
	 */
	void setOfferId(XId offerId);

	/**
	 * @return the public name of the user, could be a pseudonym. Can be null.
	 */
	String getPublicName();

	/**
	 * Internal.
	 *
	 * @param publicName
	 */
	void setPublicName(String publicName);

	/**
	 * @return a user-defined or auto-created secret to be used in secret links.
	 *         Should usually not be changed afterwards because URLs would
	 *         break.
	 */
	String getSecretKey();

	/**
	 * Internal.
	 *
	 * @param secretKey
	 *            to be set
	 *
	 * @param secret
	 *            part of URLs
	 */
	void setSecretKey(String secretKey);

}
