package com.calpano.common.shared.session;

import org.xydra.base.XId;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.store.session.ChangeSession;
import org.xydra.store.session.ISessionPersistence;
import org.xydra.store.session.SessionModel;

import com.calpano.common.shared.util.SharedExceptionUtils_GwtEmul;

/**
 * A session is a set of {@link SessionModel SessionModels}. It always gives
 * back the same references.
 *
 * A {@link SessionModel} is a buffer for reads and writes on a not necessarily
 * existent model.
 *
 * @author xamde
 *
 */
public class SharedSession extends ChangeSession {

	@SuppressWarnings("unused")
	private static String lastStacktrace = null;

	@SuppressWarnings("unused")
	private static final Logger log = LoggerFactory.getLogger(SharedSession.class);

	/** some statistics for debugging, will be inaccurate with multiple threads */
	private static long sessionsCreated = 0;

	/**
	 * @param sessionPersistence
	 * @param readonly
	 *            a flag marking an intent
	 * @param actorId
	 *            never null
	 */
	protected SharedSession(final ISessionPersistence sessionPersistence, final boolean readonly, final XId actorId) {
		super(sessionPersistence, readonly, actorId);

		if (sessionsCreated > 0) {
			// log.warn("Last session opened and not closed by " +
			// lastStacktrace);
			// log.warn("I'm opening from here: " +
			// ExceptionUtils.getStacktraceAsString());

			// SharedExceptionUtils_GwtEmul.dumpWhereStacktracesAreDifferent("opened and not closed",
			// lastStacktrace, "trying to open here",
			// SharedExceptionUtils_GwtEmul.getStacktraceAsString() + "", 3);
		}

		sessionsCreated++;
		lastStacktrace = SharedExceptionUtils_GwtEmul.getStacktraceAsString().toString();
	}

	@Override
	public void close() {
		super.close();
		sessionsCreated--;
	}

	@Override
	public void closeAndIgnoreOpenChanges() {
		super.closeAndIgnoreOpenChanges();
		sessionsCreated--;
	}

	public static SharedSession createSession(final ISessionPersistence sessionPersistence,
			final boolean readonly, final XId actorId) {
		return new SharedSession(sessionPersistence, readonly, actorId);
	}

}
