package com.calpano.common.shared.data;

import com.google.web.bindery.event.shared.Event;

/**
 * Should be fired when the app reaches on of the defined
 * {@link GlobalDataState} states
 *
 * @author xamde
 */
public class GlobalDataStateEvent extends Event<IGlobalDataStateHandler> {

	public static Type<IGlobalDataStateHandler> TYPE = new Type<IGlobalDataStateHandler>();

	@Override
	public Type<IGlobalDataStateHandler> getAssociatedType() {
		return TYPE;
	}

	private GlobalDataState dataState = GlobalDataState.getInitial();

	/**
	 * @param dataState
	 * @NeverNull
	 */
	public GlobalDataStateEvent(final GlobalDataState dataState) {
		super();
		this.dataState = dataState;
	}

	@Override
	protected void dispatch(final IGlobalDataStateHandler handler) {
		handler.onState(this);
	}

	public GlobalDataState getGlobalDataState() {
		return this.dataState;
	}

}
