package com.calpano.common.client.view.forms.suggestion;

import com.calpano.common.client.ClientApp;
import com.google.gwt.user.client.ui.TextBoxBase;
import com.google.web.bindery.event.shared.Event;

/**
 * Fired just before suggestions are hidden.
 *
 * @author xamde
 */
public class HideSuggestionEvent extends Event<HideSuggestionHandler> {

	public static Type<HideSuggestionHandler> TYPE = new Type<HideSuggestionHandler>();

	@Override
	public Type<HideSuggestionHandler> getAssociatedType() {
		return TYPE;
	}

	public HideSuggestionEvent(final TextBoxBase source) {
		super();
	}

	@Override
	protected void dispatch(final HideSuggestionHandler handler) {
		handler.onHideSuggestion(this);
	}

	@Override
	public TextBoxBase getSource() {
		return (TextBoxBase) super.getSource();
	}

	public static void fire(final TextBoxBase source) {
		ClientApp.getEventBus().fireEventFromSource(new HideSuggestionEvent(source), source);
	}

}
