package com.calpano.common.client.view.forms.locking.impl;

import com.calpano.common.client.view.resources.CommonResourceBundle;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Widget;

/**
 * Stateless.
 *
 * Helps to lock and unlock widgets by adding/removing CSS classes.
 */
public class LockUtils {

	/**
	 * Set disabled & add 'locked' class
	 *
	 * @param widget
	 */
	public static void lock(final Widget widget) {
		CommonResourceBundle.INSTANCE.css().ensureInjected();
		if (widget instanceof FocusWidget) {
			((FocusWidget) widget).setEnabled(false);
		}
		widget.addStyleName(CommonResourceBundle.INSTANCE.css().locked());
	}

	public static void lock(final Element element) {
		CommonResourceBundle.INSTANCE.css().ensureInjected();
		element.addClassName(CommonResourceBundle.INSTANCE.css().locked());
	}

	/**
	 * Set enabled & remove 'locked' class
	 *
	 * @param widget
	 */
	public static void unlock(final Widget widget) {
		CommonResourceBundle.INSTANCE.css().ensureInjected();
		if (widget instanceof FocusWidget) {
			((FocusWidget) widget).setEnabled(true);
		}
		widget.removeStyleName(CommonResourceBundle.INSTANCE.css().locked());
	}

	public static void unlock(final Element element) {
		CommonResourceBundle.INSTANCE.css().ensureInjected();
		element.removeClassName(CommonResourceBundle.INSTANCE.css().locked());
	}

}
