package com.calpano.common.client.view.forms.impl;

import org.xydra.annotations.Feature;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

import com.calpano.common.client.view.forms.Html5DomUtil;
import com.calpano.common.client.view.forms.IBelongsToHtml5Form;
import com.calpano.common.client.view.forms.IHtml5EnabledInputWidget;
import com.calpano.common.client.view.forms.IHtml5TextInput;
import com.calpano.common.client.view.forms.activation.ActivationHandler;
import com.calpano.common.client.view.forms.activation.DeactivationHandler;
import com.calpano.common.client.view.forms.suggestion.HideSuggestionEvent;
import com.calpano.common.client.view.forms.suggestion.ShowHideSuggestionHandler;
import com.calpano.common.client.view.forms.suggestion.ShowSuggestionEvent;
import com.calpano.common.client.view.forms.validation.InvalidationHandler;
import com.calpano.common.client.view.forms.validation.ValidationHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.TextBox;
import com.google.web.bindery.event.shared.HandlerRegistration;

/**
 * Documentation see {@link IHtml5TextInput}
 *
 * <em>Implementation Note</em>: Shares 99% of code from {@link Html5TextArea}
 *
 * @author xamde
 */
public class Html5TextBox extends TextBox implements IHtml5EnabledInputWidget, IBelongsToHtml5Form,
		ShowHideSuggestionHandler {

	private static final Logger log = LoggerFactory.getLogger(Html5TextBox.class);

	private final Html5TextBoxAndAreaPart<Html5TextBox> html5textPart;

	private boolean showSuggestions;

	/**
	 * Creates an empty text box.
	 */
	public Html5TextBox() {
		super();
		this.html5textPart = new Html5TextBoxAndAreaPart<Html5TextBox>(this, true,
				Html5DomUtil.SIMULATE_PLACEHOLDER, Html5DomUtil.SIMULATE_VALIDATION);
	}

	@Override
	public void onBrowserEvent(final Event event) {
		if (log.isTraceEnabled()) {
			log.trace("H5TxtBox event " + event.getType());
		}

		super.onBrowserEvent(event);
		this.html5textPart.onBrowserEvent(event);
	}

	@Override
	public IHtml5TextInput asHtml5TextInput() {
		return this.html5textPart;
	}

	/**
	 * Provided for UIBinder. See {@link Html5TextBoxAndAreaPart} for
	 * documentation.
	 *
	 * @param attributeValue
	 */
	public void setType(final String attributeValue) {
		this.html5textPart.setType(attributeValue);
	}

	/**
	 * Provided for UIBinder. See {@link Html5TextBoxAndAreaPart} for
	 * documentation.
	 *
	 * @param attributeValue
	 */
	public void setRequired(final String attributeValue) {
		this.html5textPart.setRequired(attributeValue);
	}

	/**
	 * Provided for UIBinder. See {@link Html5TextBoxAndAreaPart} for
	 * documentation.
	 *
	 * @param attributeValue
	 */
	public void setAutofocus(final String attributeValue) {
		this.html5textPart.setAutofocus(attributeValue);
	}

	/**
	 * Provided for UIBinder. See {@link Html5TextBoxAndAreaPart} for
	 * documentation.
	 *
	 * @param attributeValue
	 */
	public void setPlaceholder(final String attributeValue) {
		this.html5textPart.setPlaceholder(attributeValue);
	}


	@Override
	public void onLoad() {
		super.onLoad();
		this.html5textPart.onLoad();
	}

	@Override
	public void setForm(final Html5FormPanel form) {
		this.html5textPart.setForm(form);
	}

	@Override
	public Html5FormPanel getForm() {
		return this.html5textPart.getForm();
	}

	/* override required for placeholder function */
	@Feature("placeholder")
	@Override
	public String getText() {
		return this.html5textPart.getText();
	}

	@Override
	@Feature("placeholder")
	public String getRawText() {
		return super.getText();
	}

	@Override
	@Feature("placeholder")
	public void setText(final String s) {
		this.html5textPart.setText(s);
	}

	@Override
	public void setRawText(final String s) {
		super.setText(s);
	}

	@Override
	public void onUnload() {
		super.onUnload();
		this.html5textPart.onUnload();
		this.html5textPart.onBeforeRemoveFromParent();
	}

	/**
	 * See http://www.w3.org/TR/2011/WD-html5-20110525/forms.html#attr-form-
	 * autocomplete
	 *
	 * @param onOrOff
	 *            should be "on" or "off". "" means "on".
	 */
	@Override
	public void setAutocomplete(final String onOrOff) {
		this.html5textPart.setAutocomplete(onOrOff);
	}

	@Override
	public HandlerRegistration addDeactivationHandler(final DeactivationHandler handler) {
		return this.html5textPart.addDeactivationHandler(handler);
	}

	@Override
	public HandlerRegistration addActivationHandler(final ActivationHandler handler) {
		return this.html5textPart.addActivationHandler(handler);
	}

	@Override
	public HandlerRegistration addValidationHandler(final ValidationHandler handler) {
		return this.html5textPart.addValidationHandler(handler);
	}

	@Override
	public HandlerRegistration addInvalidationHandler(final InvalidationHandler handler) {
		return this.html5textPart.addInvalidationHandler(handler);
	}

	@Override
	@Feature("suggestions")
	public void onShowSuggestion(final ShowSuggestionEvent event) {
		this.showSuggestions = true;
	}

	@Override
	@Feature("suggestions")
	public void onHideSuggestion(final HideSuggestionEvent event) {
		this.showSuggestions = false;
	}

	@Feature("suggestions")
	public boolean isShowingSuggestions() {
		return this.showSuggestions;
	}

	/**
	 * @param oracle
	 *            @NeverNull
	 */
	@Feature("suggestions")
	public void suggestValuesFrom(final SuggestOracle oracle) {
		this.html5textPart.suggestValuesFrom(oracle);
	}

	@Feature("suggestions")
	public void setSuggestionsEnabled(final boolean enabled) {
		this.html5textPart.setSuggestionsEnabled(enabled);
	}

	protected int getSunkEvents() {
		return DOM.getEventsSunk(getElement());
	}

}
