package com.calpano.common.client.view.forms.activation;

import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

import com.calpano.common.client.ClientApp;
import com.calpano.common.client.view.forms.locking.impl.H5Lockable;
import com.calpano.common.client.view.forms.placeholder.IPlaceholderSupport;
import com.calpano.common.client.view.forms.placeholder.impl.H5Placeholder;
import com.calpano.common.client.view.forms.utils.FocusUtils;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.TextBoxBase;
import com.google.web.bindery.event.shared.HandlerRegistration;

/**
 * Architecture:
 *
 * {@link H5Activation}, Handlers: (de-)activation, valueChange
 *
 * extends {@link H5Placeholder}, Handlers: none
 *
 * extends {@link H5Lockable} (has a {@link TextBoxBase}), Handlers: none,
 * onBrowserEvent: nothing
 *
 * @author xamde
 *
 * @param <T>
 */
public class H5Activation<T extends TextBoxBase & IPlaceholderSupport> extends H5Placeholder<T>
		implements HasActivationHandlers, HasDeactivationHandlers, ValueChangeHandler<String> {

	private static final Logger log = LoggerFactory.getLogger(H5Activation.class);

	public H5Activation(final T base, final boolean simulatePlaceholder) {
		super(base, simulatePlaceholder);
		getTextBoxBase().addValueChangeHandler(this);
	}

	public static enum State {
		Activated, Deactivated
	}

	private static final int ACTIVATION_DEACTIVATION_EVENTS =
	// Event.ONFOCUS |

	Event.ONBLUR | Event.ONCLICK | Event.KEYEVENTS;

	private State lastFired = null;

	@Override
	public int getEventsToSink() {
		return super.getEventsToSink() | ACTIVATION_DEACTIVATION_EVENTS;
	}

	@Override
	public void onValueChange(final ValueChangeEvent<String> event) {
		fireActivated(getTextBoxBase(), null);
	}

	/**
	 * @param event
	 */
	@Override
	public void onBrowserEvent(final Event event) {
		if (log.isTraceEnabled()) {
			log.trace("H5Activ event " + event.getType());
		}

		super.onBrowserEvent(event);

		final int eventType = DOM.eventGetType(event);
		switch (eventType) {
		/* activate */
		case Event.ONCLICK:
		case Event.ONDBLCLICK:
		case Event.ONPASTE: {
			fireActivated(getTextBoxBase(), event);
		}
			break;
		/* deactivate */
		case Event.ONBLUR: {
			fireDeactivated(getTextBoxBase(), event);
		}
		}
	}

	@Override
	public void onLoad() {
		super.onLoad();
	}

	@Override
	protected void reset() {
		super.reset();
		// TODO focus danger
		FocusUtils.setFocus(getTextBoxBase(), false);
		fireDeactivated(getTextBoxBase(), null);
		this.lastFired = null;
	}

	@Override
	public HandlerRegistration addActivationHandler(final ActivationHandler handler) {
		return ClientApp.getEventBus().addHandlerToSource(ActivationEvent.TYPE,
				getTextBoxBase(), handler);
	}

	@Override
	public HandlerRegistration addDeactivationHandler(final DeactivationHandler handler) {
		return ClientApp.getEventBus().addHandlerToSource(DeactivationEvent.TYPE,
				getTextBoxBase(), handler);
	}

	protected void fireActivated(final Object source, final Event cause) {
		if (this.lastFired == State.Activated) {
			return;
		}

		if (log.isTraceEnabled()) {
			log.trace("ACTIVATED " + source);
		}

		ClientApp.getEventBus().fireEventFromSource(new ActivationEvent(source, cause), source);
		this.lastFired = State.Activated;
	}

	protected void fireDeactivated(final Object source, final Event cause) {
		if (this.lastFired != State.Activated) {
			return;
		}

		if (log.isTraceEnabled()) {
			log.trace("DEACTIVATED " + source);
		}

		ClientApp.getEventBus().fireEventFromSource(new DeactivationEvent(source, cause), this);
		this.lastFired = State.Deactivated;
	}
}
