package com.calpano.common.client.view.forms.activation;

/**
 * Fires when an input element is activated or deactivated. Never fires
 * activated twice without a deactivated in between.
 *
 * Activation: Element is focus and not left within n milliseconds afterwards.
 * Element is clicked on.
 *
 * Deactivation: Element looses focus.
 *
 *
 * Impl note: Invented because Chrome 21 sends an onFocus/onBlur event pair
 * whenever a form is added to the DOM or submitted.
 *
 */
public interface DeactivationHandler {

	/**
	 * Fired if input becomes deactivated
	 *
	 * @param event
	 */
	void onDeactivation(DeactivationEvent event);

}
