package com.calpano.common.client.view.forms.activation;

import com.calpano.common.client.view.forms.utils.EventWithCause;
import com.google.gwt.user.client.Event;

/**
 * Fired when a widget gets activated. This is simply an improved kind of being
 * focused. Activated widgets can be stacked.
 *
 * @author xamde
 */
public class ActivationEvent extends EventWithCause<Object, ActivationHandler> {

	public static Type<ActivationHandler> TYPE = new Type<ActivationHandler>();

	public static Type<ActivationHandler> getTYPE() {
		return TYPE;
	}

	@Override
	public Type<ActivationHandler> getAssociatedType() {
		return TYPE;
	}

	public ActivationEvent(final Object source, final Event cause) {
		super(source, cause);
	}

	@Override
	protected void dispatch(final ActivationHandler handler) {
		handler.onActivation(this);
	}

}
