package com.calpano.common.client.view.forms;

import com.calpano.common.client.view.forms.activation.HasActivationHandlers;
import com.calpano.common.client.view.forms.activation.HasDeactivationHandlers;
import com.calpano.common.client.view.forms.placeholder.IPlaceholderSupport;
import com.calpano.common.client.view.forms.validation.HasInvaliationHandlers;
import com.calpano.common.client.view.forms.validation.HasValidationHandlers;

/**
 * Interface to mark all implementations that share the behaviour of
 * {@link IHtml5TextInput}. Allows using delegation pattern to implement
 * {@link IHtml5TextInput} only once.
 *
 * @author xamde
 */
public interface IHtml5EnabledInputWidget extends HasActivationHandlers, HasDeactivationHandlers,
		HasValidationHandlers, HasInvaliationHandlers, IPlaceholderSupport {

	/**
	 * @return a delegator part
	 */
	IHtml5TextInput asHtml5TextInput();

	/**
	 * See http://www.w3.org/TR/2011/WD-html5-20110525/forms.html#attr-form-
	 * autocomplete
	 *
	 * @param onOrOff
	 *            should be "on" or "off". "" means "on".
	 *
	 *            Exposed for UIBinder.
	 */
	void setAutocomplete(String onOrOff);

}
