package com.calpano.common.client.view.forms;

import org.xydra.annotations.RunsInGWT;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.user.client.ui.FocusWidget;

/**
 * Edits attributes 'autofocus'.
 *
 * State: The one widget that should have the focus.
 */
@RunsInGWT(true)
public class AutofocusManager {

	private static final Logger log = LoggerFactory.getLogger(AutofocusManager.class);

	private static FocusWidget autoFocusWidget;

	/**
	 * HTML5 feature. There should only be one element with 'autofocus' per
	 * <em>page</em>.
	 *
	 * @param focusWidget
	 */
	public static void setAutofocusWidget(final FocusWidget focusWidget) {
		if (autoFocusWidget != null) {
			throw new IllegalStateException("Existing autofocus widget of type '"
					+ autoFocusWidget.getClass().getName()
					+ "' found. Only one can have autofocus.");
		}
		autoFocusWidget = focusWidget;
		Html5DomUtil.setPropertyBoolean(autoFocusWidget, "autofocus", true);
	}

	public static FocusWidget getAutofocusWidget() {
		return autoFocusWidget;
	}

	/**
	 * @param focusWidget
	 * @return true if the given focusWidget has autofocus enabled
	 */
	public static boolean isAutofocus(final FocusWidget focusWidget) {
		return focusWidget == autoFocusWidget;
	}

	public static void removeAutofocusWidget() {
		autoFocusWidget = null;
	}

	/**
	 * Must be called onLoad of page to be executed reliably. Has no effect if
	 * no widget got registered.
	 */
	public static void simulateAutofocus() {
		// attempt to get this done in any case
		Scheduler.get().scheduleDeferred(new ScheduledCommand() {

			@Override
			public void execute() {
				simulateAutofocusNow();
			}
		});
	}

	public static void simulateAutofocusNow() {
		if (autoFocusWidget == null) {
			setFocusToNone();
		} else {
			log.info("Autofocus on " + AutofocusManager.autoFocusWidget);
			AutofocusManager.autoFocusWidget.setFocus(true);
		}
	}

	@SuppressWarnings("unused")
	private static final String FOCUS_NONE = "focus-none";

	public static void setFocusToNone() {
		log.info("Setting focus to none");
		/*
		 * FIXME this crashes IE 8 Element a = DOM.getElementById(FOCUS_NONE);
		 * if(a == null) { a = DOM.createInputText(); a.setId(FOCUS_NONE);
		 * a.getStyle().setPosition(Position.ABSOLUTE);
		 * a.getStyle().setZIndex(-9999); a.getStyle().setColor("#000");
		 * a.getStyle().setTop(-9999, Unit.PX); a.getStyle().setLeft(-9999,
		 * Unit.PX); a.setInnerHTML("&nbsp;");
		 * Document.get().getBody().appendChild(a); }
		 * DOMHelper.focus(FOCUS_NONE);
		 */
	}

	/**
	 * HTML5 feature.
	 *
	 * @param focusWidget
	 * @param attributeValue
	 */
	public void setAutofocus(final FocusWidget focusWidget, final String attributeValue) {
		if (attributeValue.equals("autofocus") || attributeValue.equals("")) {
			setAutofocusWidget(focusWidget);
		}
	}

	public static void setAutofocusWidget(final FocusWidget focusWidget, final boolean autofocus) {
		if (autofocus) {
			setAutofocusWidget(focusWidget);
		} else {
			if (isAutofocus(focusWidget)) {
				removeAutofocusWidget();
			}
		}
	}

}
