package com.calpano.common.client.view;

import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

import com.google.gwt.dom.client.Style.Display;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasCloseHandlers;
import com.google.gwt.event.logical.shared.HasOpenHandlers;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiChild;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;

/**
 * A widget that consists of a icon and a label that discloses the content when
 * a user clicks on the icon or label. Adapted from {@link DisclosurePanel}.
 *
 * @author alpha
 */
public class IconWithLabelDisclosurePanel extends Composite implements
		HasOpenHandlers<IconWithLabelDisclosurePanel>,
		HasCloseHandlers<IconWithLabelDisclosurePanel> {

	@SuppressWarnings("unused")
	private static final Logger log = LoggerFactory.getLogger(IconWithLabelDisclosurePanel.class);

	private Image image;

	private Widget label;

	private Widget content;

	private boolean isShowing;

	private final FlowPanel panel;

	private final FocusPanel togglePanel;

	public IconWithLabelDisclosurePanel() {
		this.togglePanel = new FocusPanel();
		this.panel = new FlowPanel();
		this.panel.getElement().getStyle().setDisplay(Display.INLINE);

		this.togglePanel.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(final ClickEvent event) {
				IconWithLabelDisclosurePanel.this.toggle();
			}
		});
		this.togglePanel.add(this.panel);
		initWidget(this.togglePanel);
	}

	private void toggle() {
		if (this.isShowing) {
			hideContent();
		} else {
			showContent();
		}
	}

	/**
	 * Opens the content panel
	 */
	public void open() {
		if (this.isShowing) {
			return;
		}
		showContent();
	}

	/**
	 * Closes the content panel
	 */
	public void close() {
		if (!this.isShowing) {
			return;
		}
		hideContent();
	}

	private void showContent() {
		this.isShowing = true;
		this.content.setVisible(true);

		OpenEvent.fire(this, this);
	}

	private void hideContent() {
		this.isShowing = false;
		this.content.setVisible(false);

		CloseEvent.fire(this, this);
	}

	/**
	 * Sets the content widget which can be opened and closed by this panel.
	 *
	 * @param content
	 */
	public void setContent(final Widget content) {
		this.content = content;
	}

	@Override
	public HandlerRegistration addCloseHandler(final CloseHandler<IconWithLabelDisclosurePanel> handler) {
		return addHandler(handler, CloseEvent.getType());
	}

	@Override
	public HandlerRegistration addOpenHandler(final OpenHandler<IconWithLabelDisclosurePanel> handler) {
		return addHandler(handler, OpenEvent.getType());
	}

	@UiChild(limit = 1, tagname = "icon")
	public void addIcon(final Widget w) {
		assert w instanceof Image;

		this.image = (Image) w;
		this.panel.add(this.image);
	}

	@UiChild(limit = 1, tagname = "label")
	public void addLabel(final Widget w) {
		assert w instanceof Label;

		this.label = w;
		this.panel.add(this.label);
	}

}
