package com.calpano.common.client.util;

import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

/**
 * Generic DOM utils
 *
 * @author alpha
 */
public class DOMHelper {

	private static final Logger log = LoggerFactory.getLogger(DOMHelper.class);

	public static native void fireClickEventOnElementById(String id)
	/*-{

	$doc.getElementById(id).click();

	}-*/;

	public static native double getPageLoadTimestamp()
	/*-{

	var epoch = $wnd.epoche;
	if (epoch == undefined) {
	  return 0;
	} else {
	  return epoch;
	}

	}-*/;

	/**
	 * Trigger one redraw if the elements height is less than or equal to the
	 * minHeight.
	 *
	 * See http://stackoverflow.com/questions/3485365/how-can-i-force-webkit-to-
	 * redraw-repaint-to-propagate-style-changes
	 *
	 * Works only for block elements.
	 *
	 * @param id
	 * @param minHeight
	 */
	public static void redrawIfShorterThan(final String id, final int minHeight) {
		final int h = getOffsetHeight(id);
		if (h <= minHeight) {
			log.info("forcing a redraw on element '" + id + "'");
			setDisplay(id, "block");
		}
	}

	public static native int getOffsetHeight(String id)
	/*-{

		return $doc.getElementById(id).offsetHeight;

	}-*/;

	public static native void setDisplay(String id, String displayMode)
	/*-{

		$doc.getElementById(id).style.display=displayMode;

	}-*/;

	public static final native void focus(String id)
	/*-{

	 $doc.getElementById(id).focus();

	}-*/;

	/**
	 * Listen natively to the HTML5 AppCache UPDATEREAD event and if so, ask
	 * user to reload.
	 */
	public static final native void addAppCacheEventListener()
	/*-{

	 	$wnd.addEventListener('load', function(e) {
			$wnd.applicationCache.addEventListener('updateready', function(e) {
				if ($wnd.applicationCache.status == $wnd.applicationCache.UPDATEREADY) {
					$wnd.applicationCache.swapCache();
					if (confirm('A new version of this site is available. Load it?')) {
						$wnd.location.reload();
					}
				} else {
					// appache didnt change
				}
			}, false);
		}, false);
	}-*/;
}
