package com.calpano.common.client;

import org.xydra.env.Env;
import org.xydra.env.IEnvironment;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

import com.calpano.common.client.AppState.AppStateListener;
import com.calpano.common.client.AppState.Stage;
import com.calpano.common.client.storage.GenericStorage;
import com.calpano.common.client.util.GwtCookieUtils;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.Window.ClosingEvent;
import com.google.gwt.user.client.Window.ClosingHandler;
import com.google.web.bindery.event.shared.EventBus;

import de.xam.p13n.shared.time.TimeProvider;

/**
 * Singleton
 *
 * @author xamde
 */
public class ClientApp implements AppStateListener, ClosingHandler, CloseHandler<Window> {

	private static final Logger log = LoggerFactory.getLogger(ClientApp.class);

	private static ClientApp INSTANCE;

	private final IEnvironment env;

	public ClientApp(final IEnvironment env) {
		this.env = env;
	}

	/**
	 * @return the default instance
	 */
	public static ClientApp get() {
		if (INSTANCE == null) {
			INSTANCE = new ClientApp(Env.get());
		}
		return INSTANCE;
	}

	public static EventBus getEventBus() {
		return get().env().conf().resolve(EventBus.class);
	}

	private IEnvironment env() {
		return this.env;
	}

	private boolean isConfigSet = false;

	private static final long MILLIS_PER_MINUTE = 60 * 1000;

	/**
	 * Warning: All GWT state will be lost.
	 *
	 * Shuts down the app and starts up again. Used when user forces a reload to
	 * fetch changes, e.g. TaskList updates, Message bundle changes.
	 *
	 */
	public static void reboot() {
		log.info("Refresh");
		Window.Location.reload();
	}

	/**
	 * Reboot unless there is a cookie telling us we rebooted already in the
	 * last minute.
	 *
	 * @param env
	 */
	public static void rebootOnError(final IEnvironment env) {
		final String rebootCookie = Cookies.getCookie("reboot");
		if (rebootCookie != null) {
			final long lastReboot = Long.parseLong(rebootCookie);
			final long ago = TimeProvider.getCurrentTimeInMillis() - lastReboot;
			if (ago < MILLIS_PER_MINUTE) {
				// dont reboot
				log.info("App crashed again, dont reboot");
				return;
			}
		}
		// reboot and remember
		GwtCookieUtils.setCookie("reboot", "" + TimeProvider.getCurrentTimeInMillis(), 60);

		/* Avoid "Do you really want to quit?"-message */
		AppState.setStageSilently(Stage.Bluescreen);

		// TODO in the long term: get rid of localstorage.clear
		// auto-fix
		log.info("Clearing local storage");
		GenericStorage.clearAllLocalStorage();

		reboot();
	}

	@Override
	public void onAppStateChange() {
		setConfigurationOnce();
	}

	private void setConfigurationOnce() {
		if (this.isConfigSet) {
			return;
		}

		new ConfParamsCalpanoCommonClient().configureDefaults(this.env.conf());

		this.isConfigSet = true;
	}

	@Override
	public void onClose(final CloseEvent<Window> event) {
		// TODO Auto-generated method stub

	}

	@Override
	public void onWindowClosing(final ClosingEvent event) {
		// TODO Auto-generated method stub

	}
}
