/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.v1_1_0;

import com.calpano.kgif.util.HumanReadableText;
import com.calpano.kgif.v1_1_0.gen.Kgif;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.reflections.ReflectionUtils;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class KgifIO {
    public static final String _NS_EXPANSION_RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String _NS_EXPANSION_XSD = "http://www.w3.org/2001/XMLSchema#";
    public static final String CONTENT_TYPE_TEXT_PLAIN = "text/plain";
    public static final String CONTENT_TYPE_URI_TEXT_PLAIN = "http://purl.org/NET/mediatypes/text/plain";
    public static final String CONTENT_TYPE_URI_TEXT_PLAIN_UTF8 = "http://purl.org/NET/mediatypes/text/plain;charset=utf-8";
    public static final String CONTENT_TYPE_URI_RDF_XMLLiteral = "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral";
    public static final String CONTENT_TYPE_URI_RDF_HTML = "http://www.w3.org/1999/02/22-rdf-syntax-ns#HTML";
    public static final String CONTENT_TYPE_URI_XSD_string = "http://www.w3.org/2001/XMLSchema#string";
    public static final String CONTENT_TYPE_URI_XSD_boolean = "http://www.w3.org/2001/XMLSchema#boolean";
    public static final String CONTENT_TYPE_URI_XSD_decimal = "http://www.w3.org/2001/XMLSchema#decimal";
    public static final String CONTENT_TYPE_URI_XSD_integer = "http://www.w3.org/2001/XMLSchema#integer";
    public static final String CONTENT_TYPE_URI_XSD_double = "http://www.w3.org/2001/XMLSchema#double";
    public static final String CONTENT_TYPE_URI_XSD_float = "http://www.w3.org/2001/XMLSchema#float";
    public static final String CONTENT_TYPE_URI_XSD_date = "http://www.w3.org/2001/XMLSchema#date";
    public static final String CONTENT_TYPE_URI_XSD_time = "http://www.w3.org/2001/XMLSchema#time";
    public static final String CONTENT_TYPE_URI_XSD_dateTime = "http://www.w3.org/2001/XMLSchema#dateTime";
    public static final String CONTENT_TYPE_URI_XSD_dateTimeStamp = "http://www.w3.org/2001/XMLSchema#dateTimeStamp";
    public static final String CONTENT_TYPE_URI_XSD_gYear = "http://www.w3.org/2001/XMLSchema#gYear";
    public static final String CONTENT_TYPE_URI_XSD_gMonth = "http://www.w3.org/2001/XMLSchema#gMonth";
    public static final String CONTENT_TYPE_URI_XSD_gDay = "http://www.w3.org/2001/XMLSchema#gDay";
    public static final String CONTENT_TYPE_URI_XSD_gYearMonth = "http://www.w3.org/2001/XMLSchema#gYearMonth";
    public static final String CONTENT_TYPE_URI_XSD_gMonthDay = "http://www.w3.org/2001/XMLSchema#gMonthDay";
    public static final String CONTENT_TYPE_URI_XSD_duration = "http://www.w3.org/2001/XMLSchema#duration";
    public static final String CONTENT_TYPE_URI_XSD_yearMonthDuration = "http://www.w3.org/2001/XMLSchema#yearMonthDuration";
    public static final String CONTENT_TYPE_URI_XSD_dayTimeDuration = "http://www.w3.org/2001/XMLSchema#dayTimeDuration";
    public static final String CONTENT_TYPE_URI_XSD_byte = "http://www.w3.org/2001/XMLSchema#byte";
    public static final String CONTENT_TYPE_URI_XSD_short = "http://www.w3.org/2001/XMLSchema#short";
    public static final String CONTENT_TYPE_URI_XSD_int = "http://www.w3.org/2001/XMLSchema#int";
    public static final String CONTENT_TYPE_URI_XSD_long = "http://www.w3.org/2001/XMLSchema#long";
    public static final String CONTENT_TYPE_URI_XSD_unsignedByte = "http://www.w3.org/2001/XMLSchema#unsignedByte";
    public static final String CONTENT_TYPE_URI_XSD_unsignedShort = "http://www.w3.org/2001/XMLSchema#unsignedShort";
    public static final String CONTENT_TYPE_URI_XSD_unsignedInt = "http://www.w3.org/2001/XMLSchema#unsignedInt";
    public static final String CONTENT_TYPE_URI_XSD_unsignedLong = "http://www.w3.org/2001/XMLSchema#unsignedLong";
    public static final String CONTENT_TYPE_URI_XSD_positiveInteger = "http://www.w3.org/2001/XMLSchema#positiveInteger";
    public static final String CONTENT_TYPE_URI_XSD_nonNegativeInteger = "http://www.w3.org/2001/XMLSchema#nonNegativeInteger";
    public static final String CONTENT_TYPE_URI_XSD_negativeInteger = "http://www.w3.org/2001/XMLSchema#negativeInteger";
    public static final String CONTENT_TYPE_URI_XSD_nonPositiveInteger = "http://www.w3.org/2001/XMLSchema#nonPositiveInteger";
    public static final String CONTENT_TYPE_URI_XSD_hexBinary = "http://www.w3.org/2001/XMLSchema#hexBinary";
    public static final String CONTENT_TYPE_URI_XSD_base64Binary = "http://www.w3.org/2001/XMLSchema#base64Binary";
    public static final String CONTENT_TYPE_URI_XSD_anyURI = "http://www.w3.org/2001/XMLSchema#anyURI";
    public static final String CONTENT_TYPE_URI_XSD_language = "http://www.w3.org/2001/XMLSchema#language";
    public static final String CONTENT_TYPE_URI_XSD_normalizedString = "http://www.w3.org/2001/XMLSchema#normalizedString";
    public static final String CONTENT_TYPE_URI_XSD_token = "http://www.w3.org/2001/XMLSchema#token";
    public static final String CONTENT_TYPE_URI_XSD_NMTOKEN = "http://www.w3.org/2001/XMLSchema#NMTOKEN";
    public static final String CONTENT_TYPE_URI_XSD_Name = "http://www.w3.org/2001/XMLSchema#Name";
    public static final String CONTENT_TYPE_URI_XSD_NCName = "http://www.w3.org/2001/XMLSchema#NCName";
    public static final Set<String> RDF11_RECOMMENDED_XSD_TYPES = Sets.newHashSet((Object[])new String[]{"http://www.w3.org/2001/XMLSchema#token", "http://www.w3.org/2001/XMLSchema#gDay", "http://www.w3.org/2001/XMLSchema#nonNegativeInteger", "http://www.w3.org/2001/XMLSchema#language", "http://www.w3.org/2001/XMLSchema#float", "http://www.w3.org/2001/XMLSchema#unsignedLong", "http://www.w3.org/2001/XMLSchema#long", "http://www.w3.org/2001/XMLSchema#date", "http://www.w3.org/2001/XMLSchema#normalizedString", "http://www.w3.org/2001/XMLSchema#decimal", "http://www.w3.org/2001/XMLSchema#dayTimeDuration", "http://www.w3.org/2001/XMLSchema#unsignedInt", "http://www.w3.org/2001/XMLSchema#string", "http://www.w3.org/2001/XMLSchema#NMTOKEN", "http://www.w3.org/2001/XMLSchema#short", "http://www.w3.org/2001/XMLSchema#duration", "http://www.w3.org/2001/XMLSchema#boolean", "http://www.w3.org/2001/XMLSchema#unsignedShort", "http://www.w3.org/2001/XMLSchema#dateTimeStamp", "http://www.w3.org/2001/XMLSchema#byte", "http://www.w3.org/2001/XMLSchema#nonPositiveInteger", "http://www.w3.org/2001/XMLSchema#gYear", "http://www.w3.org/2001/XMLSchema#time", "http://www.w3.org/2001/XMLSchema#int", "http://www.w3.org/2001/XMLSchema#yearMonthDuration", "http://www.w3.org/2001/XMLSchema#gMonthDay", "http://www.w3.org/2001/XMLSchema#NCName", "http://www.w3.org/2001/XMLSchema#gYearMonth", "http://www.w3.org/2001/XMLSchema#dateTime", "http://www.w3.org/2001/XMLSchema#hexBinary", "http://www.w3.org/2001/XMLSchema#unsignedByte", "http://www.w3.org/2001/XMLSchema#anyURI", "http://www.w3.org/2001/XMLSchema#integer", "http://www.w3.org/2001/XMLSchema#positiveInteger", "http://www.w3.org/2001/XMLSchema#double", "http://www.w3.org/2001/XMLSchema#base64Binary", "http://www.w3.org/2001/XMLSchema#Name", "http://www.w3.org/2001/XMLSchema#gMonth", "http://www.w3.org/2001/XMLSchema#negativeInteger"});
    public static final Set<String> RDF11_ADDITIONAL_DATATYPES = Sets.newHashSet((Object[])new String[]{"http://www.w3.org/1999/02/22-rdf-syntax-ns#HTML", "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"});
    public static final String CONTENT_TYPE_URI_XYDRA_STRING = "http://purl.org/net/xydra/datatypes#string";
    public static final String LATEST_VERSION_DATE = "2015-04-16";
    public static final String LATEST_VERSION_NUMBER = "1.1.0";
    private static final Logger log = LoggerFactory.getLogger(KgifIO.class);
    public static final String DEFAULT_CONTENT_TYPE_FOR_KGIF_LABELS = "http://www.w3.org/2001/XMLSchema#string";
    public static final String METADATA_KEY_FILE__GRAPH_COUNT = "graphCount";
    public static final String METADATA_KEY_GRAPH__REVISION = "revision";
    public static final String METADATA_KEY_GRAPH__ENTITY_COUNT = "entityCount";
    public static final String METADATA_KEY_GRAPH__TAGCLOUD = "tagCloud";
    public static final String METADATA_KGIF_SCHEMA_VERSION_CURRENT = "1.1.0";

    public static void main(String[] args) {
        Set fields = ReflectionUtils.getAllFields(KgifIO.class, (Predicate)ReflectionUtils.withType(String.class));
        for (Field f : fields) {
            System.out.println(f.getName() + ",");
        }
    }

    public static String fileCreationDate(File f) throws IOException {
        long fileCreation;
        if (f.exists()) {
            BasicFileAttributes attr = Files.readAttributes(f.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            fileCreation = attr.creationTime().toMillis();
        } else {
            fileCreation = System.currentTimeMillis();
        }
        String fileCreationDate = HumanReadableText.fullDateTimeIso(fileCreation);
        return fileCreationDate;
    }

    public static Kgif readToDocument(Reader r) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Kgif.class});
        Unmarshaller un = context.createUnmarshaller();
        Object kgif = un.unmarshal(r);
        return (Kgif)kgif;
    }
}

