/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.v1_0_1.write;

import com.calpano.kgif.v1_0_1.gen.Attribute;
import com.calpano.kgif.v1_0_1.gen.Header;
import com.calpano.kgif.v1_0_1.gen.Metadata;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class KgifReads {
    public static void getNamespacesToMap(Header header, Map<String, String> nsMap) {
        assert (header != null);
        Metadata metadata = header.getMetadata();
        if (metadata == null) {
            return;
        }
        List<Attribute> list = metadata.getAttribute();
        if (list == null) {
            return;
        }
        for (Attribute att : list) {
            if (!att.getName().startsWith("namespace-")) continue;
            String nsPrefix = att.getName().substring("namespace-".length());
            String nsExpansion = att.getContent();
            nsMap.put(nsPrefix, nsExpansion);
        }
    }

    public static String getMetadataAttribute(Metadata metadata, String attributeName) {
        if (metadata == null) {
            return null;
        }
        List<Attribute> list = metadata.getAttribute();
        if (list == null) {
            return null;
        }
        for (Attribute att : list) {
            if (!att.getName().equals(attributeName)) continue;
            return att.getContent();
        }
        return null;
    }

    public static List<String> getMetadataAttributeAsList(Metadata metadata, String attributeName) {
        ArrayList<String> values = new ArrayList<String>();
        if (metadata == null) {
            return values;
        }
        List<Attribute> list = metadata.getAttribute();
        if (list == null) {
            return values;
        }
        for (Attribute att : list) {
            if (!att.getName().equals(attributeName)) continue;
            values.add(att.getContent());
        }
        return values;
    }

    public static String getAttributeValue(Metadata metadata, String attName, String defaultValue) {
        if (metadata == null) {
            return defaultValue;
        }
        for (Attribute att : metadata.getAttribute()) {
            if (!att.getName().equals(attName)) continue;
            return att.getContent();
        }
        return defaultValue;
    }
}

