/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.io.rdf;

import com.calpano.kgif.io.FileFormat;
import com.calpano.kgif.io.FileFormats;
import de.xam.itemset.impl.ItemSets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.xydra.base.XId;
import org.xydra.base.id.XidCodec;

public class RdfCommon {
    public static final String _DWZ_NS_EXPANSION = "http://id.denkwerkzeug.com/";
    public static final String _KGIF_NS_EXPANSION = "http://www.xam.de/ns/kgif/v1.0.0/";
    public static final String _OWL_NS_EXPANSION = "http://www.w3.org/2002/07/owl#";
    public static final String _RDF_NS_EXPANSION = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String _RDFS_NS_EXPANSION = "http://www.w3.org/2000/01/rdf-schema#";
    private static final String _XSD_NS_EXPANSION = "http://www.w3.org/2001/XMLSchema#";
    public static final String DISPLAY_AS_PROPERTY = "pmodel-att-displayAsProperty";
    public static final String DWZ_CONTENT = "http://www.xam.de/ns/kgif/v1.0.0/content";
    public static final String DWZ_CONTENT_TYPE = "http://www.xam.de/ns/kgif/v1.0.0/contentType";
    public static final String DWZ_PARSE_TYPE = "http://www.xam.de/ns/kgif/v1.0.0/parseType";
    public static Map<String, String> NS_MAP_DEFAULTS = new HashMap<String, String>();
    public static final FileFormat FILEFORMAT_RDF_NTRIPLES = new FileFormat("ntriples", "Resource Description Format (RDF)", "N-Triples", null, new String[]{"nt", "nt.txt"}, "application/n-triples", 1.0, "Defined in http://www.w3.org/TR/n-triples/");
    public static final String RDF_OBJECT = "http://www.w3.org/1999/02/22-rdf-syntax-ns#rdf:object";
    public static final String RDF_PREDICATE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#predicate";
    public static final String RDF_STATEMENT = "http://www.w3.org/1999/02/22-rdf-syntax-ns#Statement";
    public static final String RDF_SUBJECT = "http://www.w3.org/1999/02/22-rdf-syntax-ns#subject";
    public static final String RDF_TYPE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#type";
    public static final FileFormat FILEFORMAT_RDF_XML = new FileFormat("rdf/xml", "Resource Description Format (RDF)", "RDF/XML", null, new String[]{"rdf", "rdf.xml", "owl", "rdfs.xml", "owl.xml"}, "application/rdf+xml", 1.0, "Defined in http://www.w3.org/TR/rdf-syntax-grammar/");
    public static final String RDFS_LABEL = "http://www.w3.org/2000/01/rdf-schema#label";
    public static final String RDFS_SUBCLASSOF = "http://www.w3.org/2000/01/rdf-schema#subClassOf";
    public static final String RDFS_SUBPROPERTYOF = "http://www.w3.org/2000/01/rdf-schema#subPropertyOf";
    public static final String XSD_STRING = "http://www.w3.org/2001/XMLSchema#string";

    public static void init() {
        FileFormats.register((FileFormat)FILEFORMAT_RDF_NTRIPLES);
        FileFormats.register((FileFormat)FILEFORMAT_RDF_XML);
        NS_MAP_DEFAULTS.put("kgif", _KGIF_NS_EXPANSION);
        NS_MAP_DEFAULTS.put("", _DWZ_NS_EXPANSION);
        NS_MAP_DEFAULTS.put("rdf", _RDF_NS_EXPANSION);
        NS_MAP_DEFAULTS.put("rdfs", _RDFS_NS_EXPANSION);
        NS_MAP_DEFAULTS.put("owl", _OWL_NS_EXPANSION);
        NS_MAP_DEFAULTS.put("xsd", _XSD_NS_EXPANSION);
    }

    protected static String createRandomUniqueId() {
        return "r" + UUID.randomUUID().toString();
    }

    public static boolean isRdfFormat(String format) {
        return format.equals(FILEFORMAT_RDF_XML.getFormatName()) || format.equals(FILEFORMAT_RDF_NTRIPLES.getFormatName());
    }

    protected static String toKgifId(String uri, Map<String, String> namespaceMap) {
        String prefixedUri = ItemSets.abbreviate((String)uri, namespaceMap, (String)":");
        if (prefixedUri == null) {
            return uri;
        }
        return prefixedUri;
    }

    public static XId toXidFromFullUri(String fullUri, Map<String, String> nsMap) {
        String shortUri = ItemSets.abbreviate((String)fullUri, nsMap, (String)"-");
        if (shortUri == null) {
            return XidCodec.encodeAsXId((String)fullUri, (int)100);
        }
        return XidCodec.encodeAsXId((String)shortUri, (int)100);
    }

    static {
        RdfCommon.init();
    }
}

