/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.io.rdf;

import java.util.regex.Pattern;
import org.openrdf.model.Literal;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.rio.ntriples.NTriplesUtil;

public class NTriples {
    private static final String CHAR_CLASS_PART_PN_CHARS_BASE = "A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd\u10000-\uefffF";
    public static final Pattern PATTERN_BLANK_NODE_LABEL = Pattern.compile("[_0-9A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd\u10000-\uefffF]([-_0-9.\u00b7\u0300\u036f\u203f\u2040A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd\u10000-\uefffF]*[-_0-9\u00b7\u0300\u036f\u203f\u2040A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd\u10000-\uefffF])");
    private static final ValueFactory VALUE_FACTORY = new ValueFactoryImpl();

    public static String toNTriplesLiteral(Literal openRdfLiteral) {
        StringBuffer b = new StringBuffer();
        b.append("\"");
        b.append(openRdfLiteral.getLabel());
        b.append("\"");
        assert (openRdfLiteral.getDatatype() == null || openRdfLiteral.getLanguage() == null);
        if (openRdfLiteral.getDatatype() != null) {
            b.append("^^<");
            b.append(openRdfLiteral.getDatatype().stringValue());
            b.append(">");
        } else if (openRdfLiteral.getLanguage() != null) {
            b.append("@");
            b.append(openRdfLiteral.getLanguage());
        }
        return b.toString();
    }

    static String rdfLiteralEscape(String literal) {
        String valid = literal.replace("\\", "\\\\");
        valid = valid.replace("\n", "\\n");
        valid = valid.replace("\r", "\\r");
        valid = valid.replace("\"", "\\\"");
        return valid;
    }

    public static Literal fromNTriplesLiteral(String ntriplesLiteralSyntax) {
        return NTriplesUtil.parseLiteral((String)ntriplesLiteralSyntax, (ValueFactory)VALUE_FACTORY);
    }
}

