/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.store.impl.gae.ng;

import org.xydra.base.XAddress;
import org.xydra.base.rmof.XReadableObject;
import org.xydra.base.rmof.XRevWritableObject;
import org.xydra.core.serialize.SerializedModel;
import org.xydra.core.serialize.XydraElement;
import org.xydra.core.serialize.XydraOut;
import org.xydra.core.serialize.json.JsonParser;
import org.xydra.core.serialize.json.JsonSerializer;
import org.xydra.store.impl.gae.ng.TentativeObjectState;
import org.xydra.store.impl.utils.DebugFormatter;
import org.xydra.xgae.XGae;
import org.xydra.xgae.datastore.api.SEntity;
import org.xydra.xgae.datastore.api.SKey;
import org.xydra.xgae.datastore.api.SText;
import org.xydra.xgae.datastore.api.SValue;

public class TosUtils {
    private static final String JSON = "json";
    private static final String OBJECT_EXISTS = "exists";
    private static final String USED_REV = "usedRev";

    static XRevWritableObject deserialize(XAddress modelAddress, String data) {
        JsonParser parser = new JsonParser();
        XydraElement xydraElement = parser.parse(data);
        XRevWritableObject object = SerializedModel.toObjectState((XydraElement)xydraElement, (XAddress)modelAddress);
        return object;
    }

    public static TentativeObjectState fromEntity_static(SEntity entity, XAddress modelAddress) {
        assert (entity != null);
        assert (entity.hasAttribute(USED_REV)) : "no USED_REV found in " + entity.getKey().raw() + " " + DebugFormatter.format((Object)entity.raw());
        long revUsed = (Long)entity.getAttribute(USED_REV);
        boolean objectExists = (Boolean)entity.getAttribute(OBJECT_EXISTS);
        SText jsonText = (SText)entity.getAttribute(JSON);
        String json = jsonText.getValue();
        try {
            XRevWritableObject obj = TosUtils.deserialize(modelAddress, json);
            return new TentativeObjectState((XReadableObject)obj, objectExists, revUsed);
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not deserialize TOS with key = '" + entity.getKey() + "'", e);
        }
    }

    static String serialize(XReadableObject object) {
        JsonSerializer serializer = new JsonSerializer();
        XydraOut out = serializer.create();
        out.enableWhitespace(false, false);
        SerializedModel.serialize((XReadableObject)object, (XydraOut)out);
        String data = out.getData();
        return data;
    }

    public static SEntity toEntity(SKey datastoreKey, TentativeObjectState tos) {
        SEntity e = XGae.get().datastore().createEntity(datastoreKey);
        e.setAttribute(USED_REV, tos.getModelRevision());
        assert (e.hasAttribute(USED_REV));
        String json = TosUtils.serialize((XReadableObject)tos);
        SText jsonText = XGae.get().datastore().createText(json);
        e.setAttribute(JSON, (SValue)jsonText);
        e.setAttribute(OBJECT_EXISTS, tos.exists());
        return e;
    }
}

