/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.store.impl.gae.ng;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.xydra.base.change.XAtomicEvent;
import org.xydra.sharedutils.XyAssert;
import org.xydra.store.impl.gae.changes.GaeChange;
import org.xydra.store.impl.gae.ng.CheckResult;
import org.xydra.store.impl.gae.ng.ContextBeforeCommand;

class ExecutionResult {
    private List<XAtomicEvent> events = new LinkedList<XAtomicEvent>();
    private final GaeChange.Status status;
    private final String debugHint;

    public static ExecutionResult createEventsFrom(CheckResult checkResult, ContextBeforeCommand ctxBeforeCommand) {
        XyAssert.xyAssert((ctxBeforeCommand != null ? 1 : 0) != 0);
        switch (checkResult.getStatus()) {
            case FailedPreconditions: 
            case FailedTimeout: 
            case SuccessNochange: {
                return new ExecutionResult(checkResult.getStatus(), Collections.EMPTY_LIST, checkResult.getDebugHint());
            }
            case SuccessExecuted: 
            case SuccessExecutedApplied: {
                List<XAtomicEvent> events = checkResult.getExecutionContextInTxn().toEvents(checkResult.getActorId(), ctxBeforeCommand, checkResult.inTransaction());
                return new ExecutionResult(checkResult.getStatus(), events, null);
            }
        }
        throw new AssertionError();
    }

    public String toString() {
        return (Object)((Object)this.status) + " " + (this.debugHint == null ? "" : this.debugHint) + " -> " + (this.events.size() == 1 ? this.events.get(0) + " event" : this.events.size() + " events");
    }

    public ExecutionResult(GaeChange.Status status, List<XAtomicEvent> events, String explanation) {
        XyAssert.xyAssert((status != null ? 1 : 0) != 0);
        assert (status != null);
        XyAssert.xyAssert((boolean)status.isCommitted());
        this.status = status;
        this.events = events;
        this.debugHint = explanation;
    }

    public List<XAtomicEvent> getEvents() {
        return this.events;
    }

    public GaeChange.Status getStatus() {
        return this.status;
    }

    public String getDebugHint() {
        return this.debugHint;
    }
}

