/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.store.impl.gae.changes;

import org.xydra.base.Base;
import org.xydra.base.XAddress;
import org.xydra.base.XType;
import org.xydra.xgae.XGae;
import org.xydra.xgae.datastore.api.SKey;

public class KeyStructure {
    public static final String KIND_XVALUE = "XVALUE";
    public static final String KIND_XCHANGE = "XCHANGE";

    public static SKey createEntityKey(XAddress address) {
        String kind = address.getAddressedType().name();
        return XGae.get().datastore().createKey(kind, address.toURI());
    }

    public static XAddress toAddress(SKey entityKey) {
        String combinedKeyString = entityKey.getName();
        XAddress address = Base.toAddress((String)combinedKeyString);
        assert (address.getAddressedType().toString().equals(entityKey.getKind()));
        return address;
    }

    public static SKey createChangeKey(XAddress modelAddr, long revision) {
        assert (modelAddr.getAddressedType() == XType.XMODEL);
        return XGae.get().datastore().createKey(KIND_XCHANGE, revision + modelAddr.toURI());
    }

    public static XAddress getAddressFromChangeKey(SKey key) {
        assert (key.getKind().equals(KIND_XCHANGE));
        String name = key.getName();
        int firstSlash = name.indexOf("/");
        String address = name.substring(firstSlash);
        XAddress xa = Base.toAddress((String)address);
        return xa;
    }

    static SKey createValueKey(XAddress modelAddr, long rev, int transindex) {
        assert (modelAddr.getAddressedType() == XType.XMODEL);
        return XGae.get().datastore().createKey(KIND_XVALUE, rev + "+" + transindex + "/" + modelAddr.toURI());
    }

    private static boolean isChangeKey(SKey key) {
        return key.getKind().equals(KIND_XCHANGE);
    }

    static boolean assertRevisionInKey(SKey key, long rev) {
        assert (KeyStructure.isChangeKey(key)) : "key = " + key + " with kind " + key.getKind();
        return KeyStructure.getRevisionFromChangeKey(key) == rev;
    }

    public static long getRevisionFromChangeKey(SKey key) {
        assert (KeyStructure.isChangeKey(key)) : key.toString();
        String keyStr = key.getName();
        return KeyStructure.getRevisionFromChangeKey(keyStr);
    }

    public static long getRevisionFromChangeKey(String keyStr) {
        int p = keyStr.indexOf("/");
        assert (p > 0) : keyStr;
        String revStr = keyStr.substring(0, p);
        return Long.parseLong(revStr);
    }

    public static String toString(SKey key) {
        return key.getKind() + "|" + key.getName();
    }

    public static SKey toKey(String key) {
        int index = key.indexOf("|");
        assert (index > 0);
        String kind = key.substring(0, index);
        String name = key.substring(index + 1, key.length());
        return XGae.get().datastore().createKey(kind, name);
    }
}

