/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.store.impl.gae;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.xydra.store.impl.gae.changes.KeyStructure;
import org.xydra.xgae.XGae;
import org.xydra.xgae.datastore.api.SEntity;
import org.xydra.xgae.datastore.api.SKey;

public class Memcache {
    public static final String NULL_ENTITY_KIND = "NULL-ENTITY";
    public static final SEntity NULL_ENTITY = XGae.get().datastore().createEntity(XGae.get().datastore().createKey("NULL-ENTITY", "null"));
    private static boolean useMemache_ = true;

    public static Object get(SKey key) {
        if (!useMemache_) {
            return null;
        }
        return XGae.get().memcache().get((Object)KeyStructure.toString(key));
    }

    public static Map<String, Object> getEntities(Collection<String> keys) {
        assert (keys != null);
        Map memcachedEntities = null;
        if (useMemache_) {
            memcachedEntities = XGae.get().memcache().getAll(keys);
        }
        if (memcachedEntities == null) {
            return Collections.emptyMap();
        }
        return memcachedEntities;
    }

    public static void put(SKey key, Object value) {
        if (!useMemache_) {
            return;
        }
        XGae.get().memcache().put((Object)KeyStructure.toString(key), value);
    }

    public static void clear() {
        if (!useMemache_) {
            return;
        }
        XGae.get().memcache().clear();
    }

    public static void setUseMemCache(boolean useMemcache) {
        useMemache_ = useMemcache;
    }

    public static void putChecked(SKey key, Object value) throws IOException {
        if (!useMemache_) {
            return;
        }
        XGae.get().memcache().putChecked(KeyStructure.toString(key), value);
    }
}

