/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.store.impl.gae;

import com.google.common.cache.Cache;
import org.xydra.base.XAddress;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.store.impl.gae.InstanceContext;
import org.xydra.store.impl.gae.changes.RevisionInfo;
import org.xydra.xgae.util.XGaeDebugHelper;

public class InstanceRevisionManager {
    private static final Logger log = LoggerFactory.getLogger(InstanceRevisionManager.class);
    private static final String REVMANAGER_NAME = "[.rev]";
    private final XAddress modelAddress;

    public InstanceRevisionManager(XAddress modelAddress) {
        log.debug(XGaeDebugHelper.init((String)REVMANAGER_NAME));
        this.modelAddress = modelAddress;
        assert (this.getInstanceRevisionInfo() != null);
        assert (this.getInstanceRevisionInfo().getGaeModelRevision() != null);
        assert (this.getInstanceRevisionInfo().getGaeModelRevision().getModelRevision() != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RevisionInfo getInstanceRevisionInfo() {
        Cache<String, Object> instanceContext = InstanceContext.getInstanceCache();
        String key = this.modelAddress + "/revisions";
        Cache<String, Object> cache = instanceContext;
        synchronized (cache) {
            RevisionInfo instanceRevInfo = (RevisionInfo)instanceContext.getIfPresent((Object)key);
            if (instanceRevInfo == null) {
                instanceRevInfo = new RevisionInfo(".instance-rev" + this.modelAddress);
                instanceContext.put((Object)key, (Object)instanceRevInfo);
            }
            return instanceRevInfo;
        }
    }

    public String toString() {
        return this.modelAddress + ":: instance:" + this.getInstanceRevisionInfo();
    }
}

