/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.gae.admin;

import java.util.HashMap;
import java.util.Map;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.xgae.XGae;
import org.xydra.xgae.datastore.api.SEntity;
import org.xydra.xgae.datastore.api.SKey;

public class GaeConfiguration {
    private static final Logger log = LoggerFactory.getLogger(GaeConfiguration.class);
    public static final String PROP_VALID_UTC = "validUntilUTC";
    public static final long serialVersionUID = 1L;
    private static SKey KEY_CFG;
    private final Map<String, String> map = new HashMap<String, String>();
    private transient long validUntilUTC;
    public static final boolean USE_LOCALVMCACHE = false;

    private static final SKey getConfKey() {
        if (KEY_CFG == null) {
            KEY_CFG = XGae.get().datastore().createKey("XCONF", "GaeConfig");
        }
        return KEY_CFG;
    }

    public static GaeConfiguration createWithLifetime(long lifetimeInMs) {
        GaeConfiguration conf = new GaeConfiguration();
        conf.setValidUntilUTC(System.currentTimeMillis() + lifetimeInMs);
        return conf;
    }

    private GaeConfiguration() {
    }

    public void setValidUntilUTC(long validUntilUTC) {
        this.map.put(PROP_VALID_UTC, "" + validUntilUTC);
        this.validUntilUTC = validUntilUTC;
    }

    public boolean isStillValid() {
        return System.currentTimeMillis() < this.validUntilUTC;
    }

    public void store() {
        this.assertConsistentState();
        if (XGae.get().datastore().canWriteDataStore()) {
            try {
                XGae.get().datastore().async().putEntity(this.toEntity());
            }
            catch (Throwable t) {
                log.warn("Could not store config", t);
            }
        } else {
            log.warn("Datastore offline, could not persist config.");
        }
    }

    public void assertConsistentState() {
        if (!this.map.containsKey(PROP_VALID_UTC)) {
            throw new IllegalStateException("Missing validUntilUTC");
        }
    }

    private SEntity toEntity() {
        SEntity entity = XGae.get().datastore().createEntity(GaeConfiguration.getConfKey());
        for (String key : this.map.keySet()) {
            String value = this.map.get(key);
            entity.setAttribute(key, value);
        }
        return entity;
    }

    public static GaeConfiguration load() {
        log.info("Load conf from data store. It might be out of date.");
        SEntity entity = XGae.get().datastore().sync().getEntity(GaeConfiguration.getConfKey());
        if (entity == null) {
            log.warn("No gaeConfiguration in datastore.");
            return null;
        }
        GaeConfiguration conf = new GaeConfiguration();
        for (String key : entity.getAttributes().keySet()) {
            String value = (String)entity.getAttribute(key);
            conf.map.put(key, value);
        }
        conf.assertConsistentState();
        try {
            conf.validUntilUTC = Long.parseLong(conf.map.get(PROP_VALID_UTC));
        }
        catch (NumberFormatException e) {
            log.warn("Bad config in store, setting time to live to 15 minutes");
            conf.validUntilUTC = System.currentTimeMillis() + 900000L;
        }
        return conf;
    }

    public long getTimeToLive() {
        return this.validUntilUTC - System.currentTimeMillis();
    }

    public long getValidUntilUTC() {
        return this.validUntilUTC;
    }

    public Map<String, String> map() {
        return this.map;
    }

    public boolean getAsBoolean(String propName) {
        String value = this.map.get(propName);
        if (value == null) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    public void setLifetime(long ms) {
        this.setValidUntilUTC(System.currentTimeMillis() + ms);
    }
}

